/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.gui.ButtonPressDirtyListenerSimple;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.interfaces.IConfigInfoProvider;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.smok.macrofactory.ModulesKeybindProvider;
import net.smok.macrofactory.gui.GuiEntry;
import net.smok.macrofactory.gui.GuiList;
import org.jetbrains.annotations.Nullable;

public abstract class GuiScreen<T, W extends GuiEntry<T>>
extends GuiListBase<T, W, GuiList<T, W>>
implements IKeybindConfigGui {
    protected final List<Runnable> hotkeyChangeListeners = new ArrayList<Runnable>();
    protected final ButtonPressDirtyListenerSimple dirtyListener = new ButtonPressDirtyListenerSimple();
    protected ConfigButtonKeybind activeKeybindButton;
    @Nullable
    protected IConfigInfoProvider hoverInfoProvider;
    @Nullable
    protected IDialogHandler dialogHandler;

    protected GuiScreen(int listX, int listY, String titleKey, Object ... args) {
        super(listX, listY);
        this.title = StringUtils.translate((String)titleKey, (Object[])args);
    }

    protected void drawScreenBackground(class_332 drawContext, int mouseX, int mouseY) {
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.field_22787 != null && this.field_22787.field_1687 == null) {
            this.method_57728(context, delta);
        }
        this.method_57734(context);
        this.method_57735(context);
    }

    protected int getBrowserWidth() {
        return this.field_22789 - 20;
    }

    protected int getBrowserHeight() {
        return this.field_22790 - 80;
    }

    @Nullable
    public IDialogHandler getDialogHandler() {
        return this.dialogHandler;
    }

    @Nullable
    public IConfigInfoProvider getHoverInfoProvider() {
        return this.hoverInfoProvider;
    }

    protected void closeGui(boolean showParent) {
        super.closeGui(showParent);
        this.onSettingsChanged();
        ModulesKeybindProvider.update();
    }

    protected void onSettingsChanged() {
        ConfigManager.getInstance().onConfigsChanged(this.getModId());
        if (!this.hotkeyChangeListeners.isEmpty()) {
            InputEventHandler.getKeybindManager().updateUsedKeys();
        }
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onKeyPressed(keyCode);
            return true;
        }
        if (((GuiList)this.getListWidget()).onKeyTyped(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.getParent() != GuiUtils.getCurrentScreen()) {
            this.closeGui(true);
            return true;
        }
        return false;
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        if (this.activeKeybindButton != null) {
            return true;
        }
        if (((GuiList)this.getListWidget()).onCharTyped(charIn, modifiers)) {
            return true;
        }
        return super.onCharTyped(charIn, modifiers);
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onClearSelection();
            this.setActiveKeybindButton(null);
            return true;
        }
        return false;
    }

    public String getModId() {
        return "macrofactory";
    }

    public void clearOptions() {
        this.setActiveKeybindButton(null);
        this.hotkeyChangeListeners.clear();
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        return null;
    }

    public void addKeybindChangeListener(Runnable listener) {
        this.hotkeyChangeListeners.add(listener);
    }

    public ButtonPressDirtyListenerSimple getButtonPressListener() {
        return this.dirtyListener;
    }

    public void setActiveKeybindButton(@Nullable ConfigButtonKeybind button) {
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onClearSelection();
            this.updateKeybindButtons();
        }
        this.activeKeybindButton = button;
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onSelected();
        }
    }

    protected void updateKeybindButtons() {
        for (Runnable listener : this.hotkeyChangeListeners) {
            listener.run();
        }
    }
}

