/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui.selector;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.smok.macrofactory.gui.PositionAlignment;
import net.smok.macrofactory.gui.Rect;
import net.smok.macrofactory.gui.RectContainer;
import net.smok.macrofactory.gui.selector.MacroWidget;
import net.smok.macrofactory.macros.Macro;
import net.smok.macrofactory.macros.Module;
import org.jetbrains.annotations.Nullable;

public class MacroSelectionGui
extends GuiBase {
    private static final int selectorSize = 20;
    private static final int containerSpace = 5;
    private static final int columnWidth = 25;
    private final Module module;
    private final List<MacroWidget> macroWidgets = new ArrayList<MacroWidget>();
    @Nullable
    private MacroWidget selectedWidget;
    private int lastMouseX;
    private int lastMouseY;
    private RectContainer rectContainer;

    public MacroSelectionGui(Module module) {
        this.module = module;
    }

    public void initGui() {
        super.initGui();
        List<Macro> macroList = this.module.getAll();
        int maxColumns = Math.min(5, this.field_22789 / 25);
        int maxLines = Math.min(5, this.field_22790 / 25);
        if (macroList.size() < 5) {
            maxColumns = macroList.size();
        }
        if (macroList.size() / 5 < 5) {
            maxLines = macroList.size() / 5 + 1;
        }
        int maxWidth = maxColumns * 25 - 5;
        int minY = this.field_22790 / 2 - maxLines * 25 / 2;
        int minX = this.field_22789 / 2 - maxWidth / 2;
        this.rectContainer = new RectContainer(5, 5, minX, minX + maxWidth, minY, 20);
        int i = 0;
        for (int line = 0; line < maxLines; ++line) {
            for (int column = 0; column < maxColumns && i < macroList.size(); ++column, ++i) {
                Macro macro = macroList.get(i);
                Rect rect = this.rectContainer.addRect(new PositionAlignment(true, 20));
                MacroWidget widget = new MacroWidget(rect.x(), rect.y(), rect.width(), rect.height(), macro);
                this.addWidget(widget);
                this.macroWidgets.add(widget);
            }
            if (line >= maxLines - 1) continue;
            this.rectContainer.addLine();
        }
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        boolean mouseIsMove;
        String mainText = this.selectedWidget != null ? this.selectedWidget.getSelectName() : this.module.getName();
        drawContext.method_25300(this.textRenderer, StringUtils.translate((String)mainText, (Object[])new Object[0]), this.field_22789 / 2, this.rectContainer.getMinY() - 20, -1);
        if (this.module.getAll().isEmpty()) {
            drawContext.method_25300(this.textRenderer, StringUtils.translate((String)"gui.empty_module", (Object[])new Object[0]), this.field_22789 / 2, this.rectContainer.getMinY(), -1);
            return;
        }
        boolean bl = mouseIsMove = this.lastMouseX != mouseX || this.lastMouseY != mouseY;
        if (!this.rectContainer.isMouseOver(mouseX, mouseY)) {
            this.selectedWidget = null;
            mouseIsMove = false;
        }
        for (MacroWidget widget : this.macroWidgets) {
            widget.render(drawContext, mouseX, mouseY, widget == this.selectedWidget);
            if (!mouseIsMove || !widget.isMouseOver(mouseX, mouseY)) continue;
            this.selectedWidget = widget;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void method_25419() {
        super.method_25419();
        if (this.field_22787 != null && this.selectedWidget != null) {
            this.selectedWidget.callMacro(this.field_22787);
        }
    }
}

