/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.macros;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.smok.macrofactory.HotKeyWithCallBack;
import net.smok.macrofactory.gui.selector.MacroSelectionGui;
import net.smok.macrofactory.macros.Macro;
import net.smok.macrofactory.macros.SmokUtils;

public class Module
implements IKeybindProvider {
    private final ArrayList<Macro> macros = new ArrayList();
    private final ConfigBoolean enabled = new ConfigBoolean("Enabled", true, null);
    private final ConfigString name = new ConfigString("Name", "module.default.new", "config.comment.module_name");
    private final ConfigHotkey guiKeybind = new HotKeyWithCallBack("GuiKeybind", "", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.ANY, (KeyAction)KeyAction.BOTH, (boolean)false, (boolean)true, (boolean)false, (boolean)false), "config.comment.module_hotkey", this::openGui);
    public boolean isOpen;
    public boolean configure;

    public Module() {
    }

    public Module(String name) {
        this.name.setValueFromString(name);
    }

    public Module(String name, boolean open) {
        this.name.setValueFromString(name);
        this.isOpen = open;
    }

    public String getName() {
        return this.name.getStringValue();
    }

    public ConfigString getNameConfig() {
        return this.name;
    }

    public void add(Macro macro) {
        this.macros.add(macro);
    }

    public void remove(Macro macro) {
        this.macros.remove(macro);
    }

    public ConfigBoolean getEnabled() {
        return this.enabled;
    }

    public List<Macro> getAll() {
        return this.macros;
    }

    public ConfigHotkey getGuiKeybind() {
        return this.guiKeybind;
    }

    public void addKeysToMap(IKeybindManager manager) {
        if (!this.enabled.getBooleanValue()) {
            return;
        }
        manager.addKeybindToMap(this.guiKeybind.getKeybind());
        for (Macro macro : this.macros) {
            manager.addKeybindToMap(macro.getKeybind());
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        if (!this.enabled.getBooleanValue()) {
            return;
        }
        ArrayList<ConfigHotkey> hotkeys = new ArrayList<ConfigHotkey>();
        hotkeys.add(this.guiKeybind);
        for (Macro macro : this.macros) {
            hotkeys.add(macro.getHotkey());
        }
        manager.addHotkeysForCategory("macrofactory", "macrofactory." + this.getNameConfig().getStringValue(), hotkeys);
    }

    public JsonObject getAsJsonElement() {
        JsonArray array = new JsonArray();
        for (Macro macro : this.macros) {
            array.add(macro.getAsJsonElement());
        }
        JsonObject json = new JsonObject();
        json.add("Array", (JsonElement)array);
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.name);
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.enabled);
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.guiKeybind);
        return json;
    }

    public void setValueFromJsonElement(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.name);
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.enabled);
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.guiKeybind);
        JsonArray array = json.getAsJsonArray("Array");
        for (JsonElement element1 : array) {
            Macro macro = new Macro(this);
            macro.setValueFromJsonElement(element1);
            this.macros.add(macro);
        }
    }

    private boolean openGui(KeyAction keyAction, IKeybind keybind) {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (keyAction == KeyAction.RELEASE) {
            if (currentScreen instanceof MacroSelectionGui) {
                currentScreen.method_25419();
                return true;
            }
        } else if (currentScreen == null) {
            GuiBase.openGui((class_437)new MacroSelectionGui(this));
            return true;
        }
        return false;
    }
}

