/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.data.recipes.input.ItemInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_9129;

public record SpaceStationRecipe(List<ItemInput> items, class_2960 location, class_243 antenna_position) {
    public static final Codec<SpaceStationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemInput.CODEC.listOf().fieldOf("items").forGetter(SpaceStationRecipe::items), (App)class_2960.field_25139.fieldOf("location").forGetter(SpaceStationRecipe::location), (App)class_243.field_38277.fieldOf("antenna_position").forGetter(SpaceStationRecipe::antenna_position)).apply((Applicative)instance, SpaceStationRecipe::new));

    public static class_9129 toBuffer(SpaceStationRecipe recipe, class_9129 buffer) {
        buffer.method_53002(recipe.items.size());
        recipe.items.forEach(item -> ItemInput.STREAM_CODEC.encode((Object)buffer, item));
        buffer.method_10812(recipe.location);
        buffer.method_52955(recipe.antenna_position);
        return buffer;
    }

    public static SpaceStationRecipe readFromBuffer(class_9129 buffer) {
        ArrayList<ItemInput> items = new ArrayList<ItemInput>();
        int k = buffer.readInt();
        for (int i = 0; i < k; ++i) {
            items.add((ItemInput)ItemInput.STREAM_CODEC.decode((Object)buffer));
        }
        return new SpaceStationRecipe(items, buffer.method_10810(), buffer.method_52996());
    }

    private boolean haveMaterials(class_1657 player) {
        for (ItemInput item : this.items) {
            int itemLeftToAdd = item.count();
            for (class_1792 itemType : item.getItems()) {
                if ((itemLeftToAdd -= player.method_31548().method_18861(itemType)) > 0) continue;
                break;
            }
            if (itemLeftToAdd <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean haveMaterials(ItemInput item, class_1657 player) {
        int itemLeftToAdd = item.count();
        for (class_1792 itemType : item.getItems()) {
            if ((itemLeftToAdd -= player.method_31548().method_18861(itemType)) > 0) continue;
            break;
        }
        return itemLeftToAdd <= 0;
    }

    public void removeMaterials(class_1657 player) {
        for (ItemInput item : this.items) {
            int itemLeftToRemove = item.count();
            for (class_1792 itemType : item.getItems()) {
                int count;
                while (itemLeftToRemove > 0 && (count = player.method_31548().method_18861(itemType)) > 0) {
                    int i;
                    int remainder;
                    int stacksToRemove;
                    if (count >= itemLeftToRemove) {
                        stacksToRemove = itemLeftToRemove / itemType.method_7882();
                        remainder = itemLeftToRemove % itemType.method_7882();
                        for (i = 0; i < stacksToRemove; ++i) {
                            player.method_31548().method_7378(itemType.method_7854().method_46651(itemType.method_7882()));
                        }
                        if (remainder > 0) {
                            player.method_31548().method_7378(itemType.method_7854().method_46651(remainder));
                        }
                        itemLeftToRemove = 0;
                        continue;
                    }
                    stacksToRemove = count / itemType.method_7882();
                    remainder = count % itemType.method_7882();
                    for (i = 0; i < stacksToRemove; ++i) {
                        player.method_31548().method_7378(itemType.method_7854().method_46651(itemType.method_7882()));
                    }
                    if (remainder > 0) {
                        player.method_31548().method_7378(itemType.method_7854().method_46651(remainder));
                    }
                    itemLeftToRemove -= count;
                }
            }
        }
    }

    public class_5250 getDisplayName() {
        return class_2561.method_43471((String)("station." + this.location.method_12836() + "." + this.location.method_12832()));
    }

    public class_5250 getTooltip(class_1657 player) {
        class_5250 tooltip = this.getDisplayName();
        if (player == null) {
            return tooltip;
        }
        for (ItemInput item : this.items) {
            String text = "\n" + item.getDisplayName() + " x " + item.count();
            if (this.haveMaterials(item, player)) {
                tooltip.method_10852((class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1060));
                continue;
            }
            tooltip.method_10852((class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1061));
        }
        return tooltip;
    }

    public SpaceStationRecipesManager.SpaceStationRecipeState fromRecipe(class_1657 player) {
        return new SpaceStationRecipesManager.SpaceStationRecipeState(this, this.getTooltip(player), this.haveMaterials(player));
    }
}

