/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.vehicle_upgrade;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public class FuelType {
    public static final Codec<Type> CODEC = class_3542.method_28140(Type::values);

    public static float getMegametersTraveled(int fuelQuantity, Type type) {
        if (type != null) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 19.22f * (float)fuelQuantity;
                case 1 -> 0.0f;
                case 2 -> 21.36f * (float)fuelQuantity;
                case 3, 4 -> 23.74f * (float)fuelQuantity;
                case 5 -> 26.38f * (float)fuelQuantity;
                case 6 -> 29.3f * (float)fuelQuantity;
            };
        }
        return 0.0f;
    }

    public static float getFuelNeededToGoOnPlanet(Planet actual, Planet destination, Type type) {
        float distance = class_3532.method_15382((int)(actual.distanceFromEarth() - destination.distanceFromEarth()));
        if (type != null) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> distance / 19.22f;
                case 1 -> Float.MAX_VALUE;
                case 2 -> distance / 21.36f;
                case 3, 4 -> distance / 23.74f;
                case 5 -> distance / 26.38f;
                case 6 -> distance / 29.3f;
            };
        }
        return Float.MAX_VALUE;
    }

    public static class_1792 getItemBasedOnLoacation(class_2960 location) {
        return (class_1792)ItemsRegistry.ITEMS.getRegistrar().get(location);
    }

    public static enum Type implements class_3542
    {
        FUEL(GUISprites.FUEL_OVERLAY, null),
        DIESEL(GUISprites.DIESEL_OVERLAY, null),
        HYDROGEN(GUISprites.HYDROGEN_OVERLAY, null),
        RADIOACTIVE(GUISprites.ENERGY_FULL, null),
        URANIUM(GUISprites.ENERGY_FULL, RADIOACTIVE),
        NEPTUNIUM(GUISprites.ENERGY_FULL, RADIOACTIVE),
        PLUTONIUM(GUISprites.ENERGY_FULL, RADIOACTIVE);

        private final class_2960 fuelTexture;
        private final Type motorType;

        private Type(class_2960 fuelTexture, Type motorType) {
            this.fuelTexture = fuelTexture;
            this.motorType = motorType;
        }

        public static Type getTypeBasedOnItem(class_1792 item) {
            if (item == null) {
                return null;
            }
            if (item.method_7854().method_31573(TagRegistry.FUEL)) {
                return FUEL;
            }
            if (item.method_7854().method_31574((class_1792)ItemsRegistry.DIESEL_BUCKET.get())) {
                return DIESEL;
            }
            if (item.method_7854().method_31574((class_1792)ItemsRegistry.HYDROGEN_BUCKET.get())) {
                return HYDROGEN;
            }
            if (item.method_7854().method_31574((class_1792)ItemsRegistry.URANIUM_INGOT.get())) {
                return URANIUM;
            }
            if (item.method_7854().method_31574((class_1792)ItemsRegistry.NEPTUNIUM_INGOT.get())) {
                return NEPTUNIUM;
            }
            if (item.method_7854().method_31574((class_1792)ItemsRegistry.PLUTONIUM_INGOT.get())) {
                return PLUTONIUM;
            }
            return null;
        }

        public static Type fromString(String name) {
            return switch (name) {
                case "fuel" -> FUEL;
                case "diesel" -> DIESEL;
                case "hydrogen" -> HYDROGEN;
                case "uranium" -> URANIUM;
                case "neptunium" -> NEPTUNIUM;
                case "plutonium" -> PLUTONIUM;
                case "radioactive" -> RADIOACTIVE;
                default -> null;
            };
        }

        public Type getMotorType() {
            return Objects.requireNonNullElse(this.motorType, this);
        }

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase();
        }

        public class_2960 getFuelTexture() {
            return this.fuelTexture;
        }
    }
}

