/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;

public class ModifiedButton
extends TexturedButton {
    private final TexturedButton.ColorTypes colorType;
    private final boolean rocketCondition;
    private final ButtonTypes type;
    private final List<String> list;
    public final int row;
    public Predicate<Integer> isVisible = i -> false;

    public ModifiedButton(int xIn, int yIn, int row, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, boolean rocketCondition, ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, int textureWidth, int textureHeight, Button.OnPress onPressIn, Component title) {
        this(xIn, yIn, row, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, rocketCondition, type, list, buttonTexture, colorType, textureWidth, textureHeight, onPressIn, DEFAULT_NARRATION, title);
    }

    public ModifiedButton(int xIn, int yIn, int row, int widthIn, int heightIn, int xTexStart, int yTexStart, int p_i244513_7_, boolean rocketCondition, ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, int textureWidth, int textureHeight, Button.OnPress p_i244513_11_, Button.CreateNarration p_i244513_12_, Component p_i244513_13_) {
        super(xIn, yIn, row, heightIn, p_i244513_13_, p_i244513_11_, p_i244513_12_);
        this.tex(buttonTexture, buttonTexture);
        this.size(textureWidth, textureHeight);
        this.setUVs(xTexStart, yTexStart);
        this.setYShift(p_i244513_7_);
        this.colorType = colorType;
        this.rocketCondition = rocketCondition;
        this.type = type;
        this.list = list;
        this.row = row;
    }

    public void setPosition(int xIn, int yIn) {
        this.setX(xIn);
        this.setY(yIn);
    }

    public void renderButton(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (mc.screen instanceof PlanetSelectionScreen) {
            this.milkyWayCategoryManager(mc, graphics, mouseX, mouseY);
            this.solarSystemToolTip(mc, graphics, mouseX, mouseY, partialTicks);
            this.planetToolTip(mc, graphics, mouseX, mouseY, partialTicks);
            this.spaceStationToolTip(mc, graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void milkyWayCategoryManager(Minecraft minecraft, GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.isHovered && this.type == ButtonTypes.MILKY_WAY_CATEGORY) {
            Screen screen = minecraft.screen;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.CATEGORY_TEXT.getString() + ": \u00a7b" + this.list.getFirst())));
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.TYPE_TEXT.getString() + ": \u00a73" + ScreenHelper.PlanetScreenHelper.SOLAR_SYSTEM_TEXT.getString())));
            graphics.renderComponentTooltip(Minecraft.getInstance().font, list, mouseX, mouseY);
        }
    }

    private void solarSystemToolTip(Minecraft minecraft, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered && this.type == ButtonTypes.SOLAR_SYSTEM_CATEGORY) {
            Screen screen = minecraft.screen;
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            String condition = this.rocketCondition ? "a" : "c";
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.CATEGORY_TEXT.getString() + ": \u00a7" + condition + this.list.get(0))).getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.PROVIDED_TEXT.getString() + ": \u00a7b" + this.list.get(1))).getVisualOrderText());
            screen.setTooltipForNextRenderPass(list);
            screen.renderWithTooltip(graphics, mouseX, mouseY, partialTick);
        }
    }

    private void planetToolTip(Minecraft minecraft, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered && this.type == ButtonTypes.PLANET_CATEGORY) {
            Screen screen = minecraft.screen;
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.TYPE_TEXT.getString() + ": \u00a73" + this.list.get(0))).getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.GRAVITY_TEXT.getString() + ": \u00a73" + this.list.get(1))).getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.OXYGEN_TEXT.getString() + ": \u00a7" + this.list.get(2))).getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.TEMPERATURE_TEXT.getString() + ": \u00a7" + this.list.get(3))).getVisualOrderText());
            screen.setTooltipForNextRenderPass(list);
            screen.renderWithTooltip(graphics, mouseX, mouseY, partialTick);
        }
    }

    private void spaceStationToolTip(Minecraft minecraft, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered && this.type == ButtonTypes.PLANET_SPACE_STATION_CATEGORY) {
            PlanetSelectionScreen screen = (PlanetSelectionScreen)minecraft.screen;
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.ITEM_REQUIREMENT_TEXT.getString())).getVisualOrderText());
            list.add(Component.literal((String)"\u00a7c----------------").getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.TYPE_TEXT.getString() + ": \u00a73" + this.list.get(0))).getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.GRAVITY_TEXT.getString() + ": \u00a73" + this.list.get(1))).getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.OXYGEN_TEXT.getString() + ": \u00a7" + this.list.get(2))).getVisualOrderText());
            list.add(Component.literal((String)("\u00a79" + ScreenHelper.PlanetScreenHelper.TEMPERATURE_TEXT.getString() + ": \u00a7" + this.list.get(3))).getVisualOrderText());
            screen.setTooltipForNextRenderPass(list);
            screen.renderWithTooltip(graphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected Vec3 getTypeColor() {
        if (this.isHovered) {
            return TexturedButton.ColorTypes.WHITE.getColor();
        }
        if (this.type == ButtonTypes.SOLAR_SYSTEM_CATEGORY ? !this.rocketCondition : this.type == ButtonTypes.PLANET_SPACE_STATION_CATEGORY) {
            return TexturedButton.ColorTypes.RED.getColor();
        }
        return this.colorType.getColor();
    }

    public static enum ButtonTypes {
        MILKY_WAY_CATEGORY,
        SOLAR_SYSTEM_CATEGORY,
        PLANET_CATEGORY,
        PLANET_SPACE_STATION_CATEGORY;

    }
}

