/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities;

import com.st0x0ef.stellaris.common.blocks.RadioactiveBlock;
import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RadioactiveBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    private final int radioactivityLevel;
    private int tickCount = 0;

    public RadioactiveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.RADIOACTIVE_BLOCK.get(), pos, state);
        Block block = state.getBlock();
        if (block instanceof RadioactiveBlock) {
            RadioactiveBlock block2 = (RadioactiveBlock)block;
            this.radioactivityLevel = block2.getRadioactivityLevel();
            return;
        }
        this.radioactivityLevel = 0;
    }

    @Override
    public void tick() {
        AABB aabb = new AABB(this.getBlockPos()).inflate(5.0);
        if (this.tickCount >= 100) {
            List entities = this.level.getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity entity : entities) {
                if (Utils.isLivingInJetSuit(entity) || entity.getType().is(TagRegistry.ENTITY_RADIATION_INVULNERABLE_TAG)) continue;
                entity.addEffect(new MobEffectInstance(EffectsRegistry.getHolder(EffectsRegistry.RADIOACTIVE), 100, this.radioactivityLevel));
            }
            this.tickCount = 0;
        }
        ++this.tickCount;
    }
}

