/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.entities.machines.PipeBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.BaseCableBlock;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends BaseCableBlock {
    public final int capacity;
    public final int maxIn;
    public final int maxOut;

    public PipeBlock(BlockBehaviour.Properties properties, int capacity, int maxIn, int maxOut) {
        super(properties);
        this.capacity = capacity;
        this.maxIn = maxIn;
        this.maxOut = maxOut;
    }

    @Override
    boolean isConnectable(Level level, BlockPos pos, Direction direction) {
        return Capabilities.Fluid.BLOCK.getCapability(level, pos, (Object)direction) != null;
    }

    @NotNull
    protected MapCodec<? extends PipeBlock> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)PipeBlock.propertiesCodec(), (App)Codec.INT.fieldOf("capacity").forGetter(pipe -> pipe.capacity), (App)Codec.INT.fieldOf("maxIn").forGetter(pipe -> pipe.maxIn), (App)Codec.INT.fieldOf("maxOut").forGetter(pipe -> pipe.maxOut)).apply((Applicative)instance, PipeBlock::new));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PipeBlockEntity(pos, state, this.capacity, this.maxIn, this.maxOut);
    }

    @Override
    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntityRegistry.PIPE_ENTITY.get();
    }

    @Override
    public boolean hasTicker(Level level) {
        return !level.isClientSide;
    }
}

