/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.data.recipes.input.ItemInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public record SpaceStationRecipe(List<ItemInput> items, ResourceLocation location, Vec3 antenna_position) {
    public static final Codec<SpaceStationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemInput.CODEC.listOf().fieldOf("items").forGetter(SpaceStationRecipe::items), (App)ResourceLocation.CODEC.fieldOf("location").forGetter(SpaceStationRecipe::location), (App)Vec3.CODEC.fieldOf("antenna_position").forGetter(SpaceStationRecipe::antenna_position)).apply((Applicative)instance, SpaceStationRecipe::new));

    public static RegistryFriendlyByteBuf toBuffer(SpaceStationRecipe recipe, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(recipe.items.size());
        recipe.items.forEach(item -> ItemInput.STREAM_CODEC.encode((Object)buffer, item));
        buffer.writeResourceLocation(recipe.location);
        buffer.writeVec3(recipe.antenna_position);
        return buffer;
    }

    public static SpaceStationRecipe readFromBuffer(RegistryFriendlyByteBuf buffer) {
        ArrayList<ItemInput> items = new ArrayList<ItemInput>();
        int k = buffer.readInt();
        for (int i = 0; i < k; ++i) {
            items.add((ItemInput)ItemInput.STREAM_CODEC.decode((Object)buffer));
        }
        return new SpaceStationRecipe(items, buffer.readResourceLocation(), buffer.readVec3());
    }

    private boolean haveMaterials(Player player) {
        for (ItemInput item : this.items) {
            int itemLeftToAdd = item.count();
            for (Item itemType : item.getItems()) {
                if ((itemLeftToAdd -= player.getInventory().countItem(itemType)) > 0) continue;
                break;
            }
            if (itemLeftToAdd <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean haveMaterials(ItemInput item, Player player) {
        int itemLeftToAdd = item.count();
        for (Item itemType : item.getItems()) {
            if ((itemLeftToAdd -= player.getInventory().countItem(itemType)) > 0) continue;
            break;
        }
        return itemLeftToAdd <= 0;
    }

    public void removeMaterials(Player player) {
        for (ItemInput item : this.items) {
            int itemLeftToRemove = item.count();
            for (Item itemType : item.getItems()) {
                int count;
                while (itemLeftToRemove > 0 && (count = player.getInventory().countItem(itemType)) > 0) {
                    int i;
                    int remainder;
                    int stacksToRemove;
                    if (count >= itemLeftToRemove) {
                        stacksToRemove = itemLeftToRemove / itemType.getDefaultMaxStackSize();
                        remainder = itemLeftToRemove % itemType.getDefaultMaxStackSize();
                        for (i = 0; i < stacksToRemove; ++i) {
                            player.getInventory().removeItem(itemType.getDefaultInstance().copyWithCount(itemType.getDefaultMaxStackSize()));
                        }
                        if (remainder > 0) {
                            player.getInventory().removeItem(itemType.getDefaultInstance().copyWithCount(remainder));
                        }
                        itemLeftToRemove = 0;
                        continue;
                    }
                    stacksToRemove = count / itemType.getDefaultMaxStackSize();
                    remainder = count % itemType.getDefaultMaxStackSize();
                    for (i = 0; i < stacksToRemove; ++i) {
                        player.getInventory().removeItem(itemType.getDefaultInstance().copyWithCount(itemType.getDefaultMaxStackSize()));
                    }
                    if (remainder > 0) {
                        player.getInventory().removeItem(itemType.getDefaultInstance().copyWithCount(remainder));
                    }
                    itemLeftToRemove -= count;
                }
            }
        }
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)("station." + this.location.getNamespace() + "." + this.location.getPath()));
    }

    public MutableComponent getTooltip(Player player) {
        MutableComponent tooltip = this.getDisplayName();
        if (player == null) {
            return tooltip;
        }
        for (ItemInput item : this.items) {
            String text = "\n" + item.getDisplayName() + " x " + item.count();
            if (this.haveMaterials(item, player)) {
                tooltip.append((Component)Component.literal((String)text).withStyle(ChatFormatting.GREEN));
                continue;
            }
            tooltip.append((Component)Component.literal((String)text).withStyle(ChatFormatting.RED));
        }
        return tooltip;
    }

    public SpaceStationRecipesManager.SpaceStationRecipeState fromRecipe(Player player) {
        return new SpaceStationRecipesManager.SpaceStationRecipeState(this, this.getTooltip(player), this.haveMaterials(player));
    }
}

