/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.client.screens.tablet.TabletMainScreen;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class TabletPack
extends SimpleJsonResourceReloadListener {
    public TabletPack() {
        super(Stellaris.GSON, "renderer/tablet");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        Stellaris.LOG.info("Loading Assets for Tablet Pack");
        resourceLocationJsonElementMap.forEach((key, value) -> {
            Stellaris.LOG.info("Loading tablet entry: {}", key);
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"tablet");
            TabletEntry entry = (TabletEntry)TabletEntry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            if (!TabletMainScreen.ENTRIES.containsKey(entry.id())) {
                TabletMainScreen.ENTRIES.put(entry.id(), entry);
            }
            entry.infos().forEach(info -> TabletMainScreen.INFOS.put(ResourceLocation.fromNamespaceAndPath((String)entry.id(), (String)info.id()), (TabletEntry.ItemInfo)info));
        });
    }
}

