/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data_components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.ModelUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SkinUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record RocketComponent(String skin, RocketModel model, String fuelType, int fuel, ResourceLocation fuelTexture, int tankCapacity) implements Serializable
{
    public static final Codec<RocketComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("skin").forGetter(RocketComponent::skin), (App)RocketModel.CODEC.fieldOf("model").forGetter(RocketComponent::model), (App)Codec.STRING.fieldOf("fuel_type").forGetter(RocketComponent::fuelType), (App)Codec.INT.fieldOf("fuel").forGetter(RocketComponent::fuel), (App)ResourceLocation.CODEC.fieldOf("fuel_texture").forGetter(RocketComponent::fuelTexture), (App)Codec.INT.fieldOf("fuel_capacity").forGetter(RocketComponent::tankCapacity)).apply((Applicative)instance, RocketComponent::new));
    public static final StreamCodec<ByteBuf, RocketComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, RocketComponent::skin, (StreamCodec)ByteBufCodecs.fromCodec(RocketModel.CODEC), RocketComponent::model, (StreamCodec)ByteBufCodecs.STRING_UTF8, RocketComponent::fuelType, (StreamCodec)ByteBufCodecs.INT, RocketComponent::fuel, (StreamCodec)ResourceLocation.STREAM_CODEC, RocketComponent::fuelTexture, (StreamCodec)ByteBufCodecs.INT, RocketComponent::tankCapacity, RocketComponent::new);

    public int getFuel() {
        return this.fuel;
    }

    public ResourceLocation getSkin() {
        return ResourceLocation.parse((String)this.skin);
    }

    public SkinUpgrade getSkinUpgrade() {
        return new SkinUpgrade(this.getSkin());
    }

    public RocketModel getModel() {
        return this.model;
    }

    public ModelUpgrade getModelUpgrade() {
        return new ModelUpgrade(this.model);
    }

    public MotorUpgrade getMotorUpgrade() {
        return new MotorUpgrade(this.getFuelType().getMotorType());
    }

    public FuelType.Type getFuelType() {
        FuelType.Type type = FuelType.Type.fromString(this.fuelType);
        if (type != null) {
            return type;
        }
        Item item = FuelType.getItemBasedOnLoacation(ResourceLocation.parse((String)this.fuelType));
        type = FuelType.Type.getTypeBasedOnItem(item);
        if (type != null) {
            return type;
        }
        return FuelType.Type.FUEL;
    }

    public TankUpgrade getTankUpgrade() {
        return new TankUpgrade(this.tankCapacity);
    }

    public int getTankCapacity() {
        return this.tankCapacity;
    }

    public static RocketComponent fromNetwork(RegistryFriendlyByteBuf buffer) {
        return new RocketComponent(buffer.readUtf(), RocketModel.fromString(buffer.readUtf()), buffer.readUtf(), buffer.readInt(), buffer.readResourceLocation(), buffer.readInt());
    }

    public RegistryFriendlyByteBuf toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.skin);
        buffer.writeUtf(this.model().getSerializedName());
        buffer.writeUtf(this.fuelType);
        buffer.writeInt(this.fuel);
        buffer.writeResourceLocation(this.fuelTexture);
        buffer.writeInt(this.tankCapacity);
        return buffer;
    }
}

