/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data_components;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SpaceSuitModules(List<ItemStack> modules) implements Serializable
{
    public static final Codec<SpaceSuitModules> CODEC = ItemStack.CODEC.listOf().xmap(SpaceSuitModules::new, modules -> modules.modules);
    public static final StreamCodec<RegistryFriendlyByteBuf, SpaceSuitModules> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(SpaceSuitModules::new, modules -> modules.modules);

    public static SpaceSuitModules empty() {
        return new SpaceSuitModules(List.of());
    }

    public ItemStack getItemUnsafe(int index) {
        return this.modules.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.modules.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.modules;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.modules, ItemStack::copy);
    }

    public static ItemStack getIfContains(ItemStack stack, Item module) {
        ItemStack moduleToReturn = ItemStack.EMPTY;
        SpaceSuitModules spaceSuitModules = (SpaceSuitModules)stack.getOrDefault((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get(), (Object)SpaceSuitModules.empty());
        if (spaceSuitModules.items() == null) {
            return moduleToReturn;
        }
        for (ItemStack moduleStack : spaceSuitModules.items()) {
            if (!moduleStack.is(module)) continue;
            moduleToReturn = moduleStack;
            break;
        }
        return moduleToReturn;
    }

    public static boolean containsAllInModules(ItemStack stack, List<Item> modules) {
        boolean containsAll = true;
        for (Item item : modules) {
            if (!(item instanceof SpaceSuitModule)) continue;
            SpaceSuitModule validModule = (SpaceSuitModule)item;
            if (SpaceSuitModules.containsInModules(stack, validModule)) break;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public static boolean containsInModules(ItemStack stack, ItemStack module) {
        return SpaceSuitModules.containsInModules(stack, SpaceSuitModules.getModule(module));
    }

    public static boolean containsInModules(ItemStack stack, SpaceSuitModule module) {
        if (stack.isEmpty()) {
            return false;
        }
        SpaceSuitModules spaceSuitModules = (SpaceSuitModules)stack.get((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get());
        if (spaceSuitModules == null) {
            return false;
        }
        boolean boolToReturn = false;
        for (SpaceSuitModule module1 : spaceSuitModules.getModules()) {
            if (module1 != module) continue;
            boolToReturn = true;
            break;
        }
        return boolToReturn;
    }

    public List<SpaceSuitModule> getModules() {
        return Lists.transform(this.modules, SpaceSuitModules::getModule);
    }

    private static SpaceSuitModule getModule(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof SpaceSuitModule) {
            SpaceSuitModule spaceSuitModule = (SpaceSuitModule)item;
            return spaceSuitModule;
        }
        return null;
    }

    public static class Mutable {
        private final List<ItemStack> modules;

        public Mutable(SpaceSuitModules contents) {
            this.modules = new ArrayList<ItemStack>(contents.modules);
        }

        public Mutable insert(ItemStack stack) {
            if (!stack.isEmpty() && stack.getItem().canFitInsideContainerItems()) {
                this.modules.add(stack);
            }
            return this;
        }

        public SpaceSuitModules toImmutable() {
            return new SpaceSuitModules(List.copyOf(this.modules));
        }
    }
}

