/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.effects;

import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SandStormEffect
extends MobEffect {
    public static ResourceLocation SANDSTORM_OVERLAY = ResourceLocationUtils.texture("overlay/sandstorm_overlay");

    public SandStormEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public int getBlendDurationTicks() {
        return 22;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SandStormFogFunction
    implements FogRenderer.MobEffectFogFunction {
        public Holder<MobEffect> getMobEffect() {
            return EffectsRegistry.getHolder(EffectsRegistry.SANDSTORM);
        }

        public float getModifiedVoidDarkness(LivingEntity entity, MobEffectInstance effectInstance, float f, float partialTick) {
            return f;
        }

        public void setupFog(FogRenderer.FogData fogData, LivingEntity entity, MobEffectInstance effectInstance, float farPlaneDistance, float f) {
            float g;
            float f2 = g = effectInstance.isInfiniteDuration() ? 20.0f : Mth.lerp((float)Math.min(1.0f, (float)effectInstance.getDuration() / 40.0f), (float)farPlaneDistance, (float)20.0f);
            if (fogData.mode == FogRenderer.FogMode.FOG_SKY) {
                fogData.start = 4.0f;
                fogData.end = g * 0.8f;
            } else {
                fogData.start = g * 0.25f;
                fogData.end = g;
            }
        }
    }
}

