/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.armors;

import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.common.data_components.JetSuitComponent;
import com.st0x0ef.stellaris.common.items.armors.AbstractSpaceArmor;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class JetSuit {

    public static enum ModeType implements StringRepresentable
    {
        DISABLED((Component)Component.translatable((String)"general.stellaris.jet_suit_disabled_mode"), ChatFormatting.RED, 0),
        NORMAL((Component)Component.translatable((String)"general.stellaris.jet_suit_normal_mode"), ChatFormatting.GREEN, 1),
        HOVER((Component)Component.translatable((String)"general.stellaris.jet_suit_hover_mode"), ChatFormatting.GREEN, 2),
        ELYTRA((Component)Component.translatable((String)"general.stellaris.jet_suit_elytra_mode"), ChatFormatting.GREEN, 3),
        CREATIVE((Component)Component.translatable((String)"general.stellaris.jet_suit_creative_mode"), ChatFormatting.GREEN, 4);

        private final int mode;
        private final ChatFormatting chatFormatting;
        private final Component component;
        public static final Codec<ModeType> CODEC;

        private ModeType(Component component, ChatFormatting chatFormatting, int mode) {
            this.mode = mode;
            this.chatFormatting = chatFormatting;
            this.component = component;
        }

        public ChatFormatting getChatFormatting() {
            return this.chatFormatting;
        }

        public Component getComponent() {
            return this.component;
        }

        public int getMode() {
            return this.mode;
        }

        public String getSerializedName() {
            return String.valueOf(this.mode);
        }

        public static ModeType fromInt(int integer) {
            return ModeType.fromString(Integer.toString(integer));
        }

        public static ModeType fromString(String string) {
            return switch (Integer.decode(string)) {
                case 1 -> NORMAL;
                case 2 -> HOVER;
                case 3 -> ELYTRA;
                case 4 -> CREATIVE;
                default -> DISABLED;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(ModeType::values);
        }
    }

    public static class Suit
    extends AbstractSpaceArmor.Chestplate {
        public float spacePressTime = 0.0f;
        private int nextFuelCheckTick = 0;

        public Suit(Holder<ArmorMaterial> material, Item.Properties properties) {
            super(material, ArmorItem.Type.CHESTPLATE, properties, false);
        }

        public int getMode(ItemStack itemStack) {
            return ((JetSuitComponent)itemStack.get((DataComponentType)DataComponentsRegistry.JET_SUIT_COMPONENT.get())).type().getMode();
        }

        public ModeType getModeType(ItemStack itemStack) {
            return switch (this.getMode(itemStack)) {
                case 1 -> ModeType.NORMAL;
                case 2 -> ModeType.HOVER;
                case 3 -> ModeType.ELYTRA;
                default -> ModeType.DISABLED;
            };
        }

        public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
            Player player;
            super.inventoryTick(stack, level, entity, slotId, isSelected);
            if (entity instanceof Player && (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof Suit) {
                ItemStack jetSuitItemStack = player.getItemBySlot(EquipmentSlot.CHEST);
                if (player.isSprinting()) {
                    this.boost(player, 1.3, true);
                }
                if (player.zza > 0.0f && !player.isSprinting()) {
                    this.boost(player, 0.9, false);
                }
                switch (this.getMode(stack)) {
                    case 1: {
                        this.normalFlyModeMovement(player, jetSuitItemStack);
                        break;
                    }
                    case 2: {
                        this.hoverModeMovement(player, jetSuitItemStack);
                        break;
                    }
                    case 3: {
                        this.elytraModeMovement(player, jetSuitItemStack);
                    }
                }
                this.calculateSpacePressTime(player, jetSuitItemStack);
            }
        }

        private void normalFlyModeMovement(Player player, ItemStack stack) {
            if (!player.getAbilities().flying && !player.isPassenger() && Utils.isLivingInJetSuit((LivingEntity)player) && this.getMode(stack) == ModeType.NORMAL.getMode() && !player.hasEffect(MobEffects.SLOW_FALLING)) {
                UniversalFluidItemStorage storage = this.getFluidTank(stack);
                if (storage.getFluidInTank(1).isEmpty()) {
                    return;
                }
                if (KeyVariables.isHoldingJump(player)) {
                    if (this.nextFuelCheckTick > 0) {
                        player.moveRelative(1.2f, new Vec3(0.0, 0.1, 0.0));
                        player.resetFallDistance();
                        Utils.disableFlyAntiCheat(player, true);
                    } else if (storage.getFluidInTank(1).isEmpty()) {
                        player.moveRelative(1.2f, new Vec3(0.0, 0.1, 0.0));
                        player.resetFallDistance();
                        Utils.disableFlyAntiCheat(player, true);
                        this.nextFuelCheckTick = 20;
                    }
                    --this.nextFuelCheckTick;
                    if (!player.onGround()) {
                        Vec3 movement = Vec3.ZERO;
                        if (KeyVariables.isHoldingUp(player)) {
                            movement = movement.add(player.getLookAngle().scale(0.1));
                        }
                        if (KeyVariables.isHoldingDown(player)) {
                            movement = movement.add(player.getLookAngle().scale(-0.05));
                        }
                        if (KeyVariables.isHoldingLeft(player)) {
                            movement = movement.add(Vec3.directionFromRotation((float)0.0f, (float)(player.getYRot() - 90.0f)).scale(0.1));
                        }
                        if (KeyVariables.isHoldingRight(player)) {
                            movement = movement.add(Vec3.directionFromRotation((float)0.0f, (float)(player.getYRot() + 90.0f)).scale(0.1));
                        }
                        player.setDeltaMovement(player.getDeltaMovement().add(movement));
                    }
                    if (!player.level().isClientSide) {
                        Vec3 look = player.getLookAngle();
                        ServerLevel serverLevel = (ServerLevel)player.level();
                        Vec3 particlePos = player.position().subtract(look.scale(0.75)).add(0.0, 0.25, 0.0);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLASH, particlePos.x, particlePos.y, particlePos.z, 1, 0.15, 0.15, 0.15, 0.05);
                    }
                }
            }
        }

        private void hoverModeMovement(Player player, ItemStack stack) {
            if (!player.getAbilities().flying && !player.isPassenger() && Utils.isLivingInJetSuit((LivingEntity)player) && this.getMode(stack) == ModeType.HOVER.getMode() && !player.hasEffect(MobEffects.SLOW_FALLING)) {
                Vec3 vec3 = player.getDeltaMovement();
                UniversalFluidItemStorage storage = this.getFluidTank(stack);
                if (storage.getFluidInTank(1).isEmpty()) {
                    return;
                }
                if (!player.onGround() && !player.isInWater()) {
                    if (this.nextFuelCheckTick > 0) {
                        player.setDeltaMovement(vec3.x, vec3.y + 0.04, vec3.z);
                        player.resetFallDistance();
                        Utils.disableFlyAntiCheat(player, true);
                    } else if (!storage.getFluidInTank(1).isEmpty()) {
                        player.setDeltaMovement(vec3.x, vec3.y + 0.04, vec3.z);
                        player.resetFallDistance();
                        Utils.disableFlyAntiCheat(player, true);
                        this.nextFuelCheckTick = 20;
                    }
                    --this.nextFuelCheckTick;
                }
                if (KeyVariables.isHoldingJump(player)) {
                    Utils.disableFlyAntiCheat(player, true);
                    if (player.isCrouching()) {
                        player.moveRelative(0.05f, new Vec3(0.0, -0.08, 0.0));
                    }
                    if (!player.onGround()) {
                        if (KeyVariables.isHoldingUp(player)) {
                            player.moveRelative(0.1f, new Vec3(0.0, 0.0, 0.1));
                        } else if (KeyVariables.isHoldingDown(player)) {
                            player.moveRelative(0.1f, new Vec3(0.0, 0.0, -0.1));
                        }
                    }
                    if (!player.onGround()) {
                        if (KeyVariables.isHoldingRight(player)) {
                            player.moveRelative(0.1f, new Vec3(-0.1, 0.0, 0.0));
                        } else if (KeyVariables.isHoldingLeft(player)) {
                            player.moveRelative(0.1f, new Vec3(0.1, 0.0, 0.0));
                        }
                    }
                    if (!player.level().isClientSide) {
                        Vec3 look = player.getLookAngle();
                        ServerLevel serverLevel = (ServerLevel)player.level();
                        Vec3 particlePos = player.position().subtract(look.scale(0.75)).add(0.0, 0.25, 0.0);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLASH, particlePos.x, particlePos.y, particlePos.z, 1, 0.15, 0.15, 0.15, 0.05);
                    }
                }
            }
        }

        private void elytraModeMovement(Player player, ItemStack stack) {
            if (!player.getAbilities().flying && !player.isPassenger() && Utils.isLivingInJetSuit((LivingEntity)player) && this.getMode(stack) == ModeType.ELYTRA.getMode() && !player.hasEffect(MobEffects.SLOW_FALLING)) {
                Vec3 look;
                UniversalFluidItemStorage storage = this.getFluidTank(stack);
                if (storage.getFluidInTank(1).isEmpty()) {
                    return;
                }
                if (!(player.onGround() || player.isInWater() || player.hasEffect(MobEffects.LEVITATION))) {
                    player.startFallFlying();
                    Utils.disableFlyAntiCheat(player, true);
                }
                if (player.isFallFlying() && player.isSprinting()) {
                    look = player.getLookAngle();
                    Vec3 motion = player.getDeltaMovement();
                    double boost = 0.1;
                    player.setDeltaMovement(motion.add(look.x * boost, look.y * boost, look.z * boost));
                    if (this.nextFuelCheckTick <= 0) {
                        storage.drain(storage.getFluidInTank(1), false);
                        this.nextFuelCheckTick = 20;
                    }
                    --this.nextFuelCheckTick;
                }
                if (!player.level().isClientSide) {
                    look = player.getLookAngle();
                    ServerLevel serverLevel = (ServerLevel)player.level();
                    Vec3 particlePos = player.position().subtract(look.scale(0.75)).add(0.0, 0.25, 0.0);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, particlePos.x, particlePos.y, particlePos.z, 1, 0.15, 0.15, 0.15, 0.05);
                }
            }
        }

        public void switchJetSuitMode(ItemStack itemStack) {
            JetSuitComponent jetSuitComponent = this.getMode(itemStack) < 3 ? new JetSuitComponent(ModeType.fromInt(this.getMode(itemStack) + 1)) : new JetSuitComponent(ModeType.fromInt(0));
            itemStack.set((DataComponentType)DataComponentsRegistry.JET_SUIT_COMPONENT.get(), (Object)jetSuitComponent);
        }

        public void calculateSpacePressTime(Player player, ItemStack itemStack) {
            int mode = this.getMode(itemStack);
            if (mode == ModeType.NORMAL.getMode()) {
                if (KeyVariables.isHoldingJump(player)) {
                    if (this.spacePressTime < 2.2f) {
                        this.spacePressTime += 0.2f;
                    }
                } else if (this.spacePressTime > 0.0f) {
                    this.spacePressTime -= 0.2f;
                }
            }
            if (mode == ModeType.HOVER.getMode()) {
                if (!player.onGround() && this.spacePressTime < 0.6f) {
                    this.spacePressTime += 0.2f;
                } else if (KeyVariables.isHoldingJump(player)) {
                    if (this.spacePressTime < 1.4f) {
                        this.spacePressTime += 0.2f;
                        this.hoverModeMovement(player, itemStack);
                    }
                } else if (this.spacePressTime >= 0.6f) {
                    this.spacePressTime -= 0.2f;
                }
            }
            if (mode == ModeType.ELYTRA.getMode() && KeyVariables.isHoldingUp(player) && player.isFallFlying()) {
                if (player.isSprinting()) {
                    if (this.spacePressTime < 2.8f) {
                        this.spacePressTime += 0.2f;
                    }
                } else if (this.spacePressTime < 2.2f) {
                    this.spacePressTime += 0.2f;
                }
            }
        }

        public void boost(Player player, double boost, boolean sonicBoom) {
            Vec3 vec31 = player.getLookAngle();
            if ((Utils.isLivingInJetSuit((LivingEntity)player) || Utils.isLivingInSpaceSuit((LivingEntity)player)) && player.isFallFlying()) {
                Vec3 vec32 = player.getDeltaMovement();
                player.setDeltaMovement(vec32.add(vec31.x * 0.1 + (vec31.x * boost - vec32.x) * 0.5, vec31.y * 0.1 + (vec31.y * boost - vec32.y) * 0.5, vec31.z * 0.1 + (vec31.z * boost - vec32.z) * 0.5));
                if (sonicBoom) {
                    Vec3 vec33 = player.getLookAngle().scale(6.5);
                    if (player.level() instanceof ServerLevel) {
                        for (ServerPlayer p : ((ServerLevel)player.level()).getServer().getPlayerList().getPlayers()) {
                            ((ServerLevel)player.level()).sendParticles(p, (ParticleOptions)ParticleTypes.FLAME, true, player.getX() - vec33.x, player.getY() - vec33.y, player.getZ() - vec33.z, 1, 0.0, 0.0, 0.0, 0.001);
                        }
                    }
                }
            }
        }

        @Override
        public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
            return Utils.isLivingInJetSuit(entity) && this.getMode(stack) == ModeType.ELYTRA.getMode();
        }

        @Override
        public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
            int nextFlightTick;
            if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
                entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
            }
            return true;
        }

        @Override
        public boolean tryToStartFallFlying(Player player) {
            ItemStack itemStack;
            if (!player.onGround() && !player.isFallFlying() && !player.isInWater() && !player.hasEffect(MobEffects.LEVITATION) && (itemStack = player.getItemBySlot(EquipmentSlot.CHEST)).is(ItemsRegistry.JETSUIT_SUIT) && ElytraItem.isFlyEnabled((ItemStack)itemStack)) {
                player.startFallFlying();
                return true;
            }
            return false;
        }
    }
}

