/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.st0x0ef.stellaris.common.oxygen.OxygenRoom;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DimensionOxygenManager {
    private final Set<OxygenRoom> oxygenRooms = new HashSet<OxygenRoom>();
    private final Map<BlockPos, OxygenRoom> roomToCheckIfOpen = new HashMap<BlockPos, OxygenRoom>();
    private final boolean planetHasOxygen;
    private final ServerLevel level;
    private int tickCount;

    public DimensionOxygenManager(ServerLevel level) {
        this.level = level;
        this.planetHasOxygen = PlanetUtil.hasOxygen((Level)level);
    }

    public void addOxygenRoom(BlockPos pos) {
        this.oxygenRooms.add(new OxygenRoom(this.level, pos));
    }

    public void removeOxygenRoom(BlockPos pos) {
        this.oxygenRooms.removeIf(room -> room.getDistributorPosition().equals((Object)pos));
    }

    public void addRoomToCheckIfOpen(BlockPos pos, OxygenRoom room) {
        if (!this.roomToCheckIfOpen.containsKey(pos)) {
            this.roomToCheckIfOpen.put(pos, room);
        }
    }

    public void removeRoomToCheckIfOpen(BlockPos pos) {
        this.roomToCheckIfOpen.remove(pos);
    }

    public void updateOxygenTick() {
        if (this.planetHasOxygen || this.tickCount < 20) {
            ++this.tickCount;
            return;
        }
        this.oxygenRooms.forEach(OxygenRoom::tick);
        this.roomToCheckIfOpen.values().forEach(OxygenRoom::removeOxygenInRoom);
        this.roomToCheckIfOpen.clear();
        this.tickCount = 0;
    }

    public boolean breath(LivingEntity entity) {
        UniversalFluidStorage storage;
        Player player;
        if (this.planetHasOxygen || entity.getType().is(TagRegistry.ENTITY_NO_OXYGEN_NEEDED_TAG)) {
            return true;
        }
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
            return true;
        }
        if (this.breathOxygenAt(entity.getOnPos().above())) {
            return true;
        }
        if (Utils.isLivingInOxygenatedArmor(entity)) {
            return true;
        }
        if ((Utils.isLivingInJetSuit(entity) || Utils.isLivingInSpaceSuit(entity)) && (storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(entity.getItemBySlot(EquipmentSlot.CHEST))) != null && !storage.getFluidInTank(0).isEmpty()) {
            storage.drain(storage.getFluidInTank(0).copyWithAmount(1L), false);
            return true;
        }
        return false;
    }

    public boolean breathOxygenAt(BlockPos pos) {
        return this.oxygenRooms.stream().anyMatch(room -> room.breathOxygenAt(pos));
    }

    public boolean hasOxygenAt(BlockPos pos) {
        return this.oxygenRooms.stream().anyMatch(room -> room.hasOxygenAt(pos));
    }

    public OxygenRoom getOxygenRoom(BlockPos distributorPos) {
        return this.oxygenRooms.stream().filter(room -> room.getDistributorPosition().equals((Object)distributorPos)).findFirst().orElse(null);
    }

    public ServerLevel getLevel() {
        return this.level;
    }
}

