/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin;

import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.entities.CustomLightningBolt;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class StormyPlanetMixin {
    @Inject(at={@At(value="HEAD")}, method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"})
    public void spawnMoreLightningBolt(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        ServerLevel level = (ServerLevel)this;
        PlanetUtil.ifPlanet(level.dimension().location(), planet -> {
            if (planet.stormParameters().isPresent()) {
                Planet.StormParameters parameters = planet.stormParameters().get();
                ChunkPos chunkPos = chunk.getPos();
                if (level.random.nextInt(parameters.lightningFrequency()) == 0) {
                    BlockPos pos = level.findLightningTargetAround(level.getBlockRandomPos(chunkPos.getMinBlockX(), 0, chunkPos.getMinBlockZ(), 15));
                    CustomLightningBolt lightningBolt = (CustomLightningBolt)((EntityType)EntityRegistry.CUSTOM_LIGHTNING_BOLT.get()).create((Level)level);
                    if (lightningBolt != null) {
                        lightningBolt.setCustomColor(parameters.lightningColor());
                        lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                        lightningBolt.setVisualOnly(false);
                        level.addFreshEntity((Entity)lightningBolt);
                    }
                }
            }
        });
    }
}

