/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.events.ClientEvents;
import com.st0x0ef.stellaris.client.overlays.EffectOverlays;
import com.st0x0ef.stellaris.client.overlays.JetSuitOverlay;
import com.st0x0ef.stellaris.client.overlays.LanderOverlay;
import com.st0x0ef.stellaris.client.overlays.RocketBarOverlay;
import com.st0x0ef.stellaris.client.overlays.RocketStartOverlay;
import com.st0x0ef.stellaris.client.overlays.SpaceSuitOverlay;
import com.st0x0ef.stellaris.client.particles.RocketParticle;
import com.st0x0ef.stellaris.client.particles.VenusRainParticle;
import com.st0x0ef.stellaris.client.renderers.armors.JetSuitModel;
import com.st0x0ef.stellaris.client.renderers.armors.SpaceSuitModel;
import com.st0x0ef.stellaris.client.screens.ConfigScreen;
import com.st0x0ef.stellaris.common.data.screen.MoonPack;
import com.st0x0ef.stellaris.common.data.screen.PlanetPack;
import com.st0x0ef.stellaris.common.data.screen.StarPack;
import com.st0x0ef.stellaris.common.data.screen.TabletPack;
import com.st0x0ef.stellaris.common.handlers.GlobalExceptionHandler;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.ParticleRegistry;
import com.st0x0ef.stellaris.platform.ClientUtilsPlatform;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLDebugMessageCallback;

@OnlyIn(value=Dist.CLIENT)
public class StellarisClient {
    public static void initClient() {
        Minecraft.getInstance().execute(() -> {
            StellarisClient.setupOpenGLDebugMessageCallback();
            Thread.setDefaultUncaughtExceptionHandler(new GlobalExceptionHandler());
        });
        StellarisClient.registerParticle();
        StellarisClient.registerOverlays();
        StellarisClient.registerArmors();
        Platform.getMod((String)"stellaris").registerConfigurationScreen(ConfigScreen::new);
        ClientEvents.registerEvents();
    }

    private static void registerArmors() {
        ClientUtilsPlatform.registerArmor(JetSuitModel.LAYER_LOCATION, JetSuitModel::new, (Item)ItemsRegistry.JETSUIT_BOOTS.get(), (Item)ItemsRegistry.JETSUIT_LEGGINGS.get(), (Item)ItemsRegistry.JETSUIT_HELMET.get(), (Item)ItemsRegistry.JETSUIT_SUIT.get());
        ClientUtilsPlatform.registerArmor(SpaceSuitModel.LAYER_LOCATION, SpaceSuitModel::new, (Item)ItemsRegistry.SPACESUIT_BOOTS.get(), (Item)ItemsRegistry.SPACESUIT_LEGGINGS.get(), (Item)ItemsRegistry.SPACESUIT_HELMET.get(), (Item)ItemsRegistry.SPACESUIT_SUIT.get());
        ColorHandlerRegistry.registerItemColors((stack, color) -> color > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-1), (ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.JETSUIT_BOOTS.get(), (ItemLike)ItemsRegistry.JETSUIT_HELMET.get(), (ItemLike)ItemsRegistry.JETSUIT_LEGGINGS.get(), (ItemLike)ItemsRegistry.SPACESUIT_BOOTS.get(), (ItemLike)ItemsRegistry.JETSUIT_SUIT.get(), (ItemLike)ItemsRegistry.SPACESUIT_SUIT.get(), (ItemLike)ItemsRegistry.SPACESUIT_HELMET.get(), (ItemLike)ItemsRegistry.SPACESUIT_LEGGINGS.get()});
    }

    public static void registerParticle() {
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.VENUS_RAIN_PARTICLE.get()), VenusRainParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.LARGE_FLAME_PARTICLE.get()), RocketParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.LARGE_SMOKE_PARTICLE.get()), RocketParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.SMALL_FLAME_PARTICLE.get()), RocketParticle.SmallProvider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.SMALL_SMOKE_PARTICLE.get()), RocketParticle.SmallProvider::new);
    }

    public static void registerOverlays() {
        ClientGuiEvent.RENDER_HUD.register(EffectOverlays::render);
        ClientGuiEvent.RENDER_HUD.register(RocketStartOverlay::render);
        ClientGuiEvent.RENDER_HUD.register(RocketBarOverlay::render);
        ClientGuiEvent.RENDER_HUD.register(LanderOverlay::render);
        ClientGuiEvent.RENDER_HUD.register(JetSuitOverlay::render);
        ClientGuiEvent.RENDER_HUD.register(SpaceSuitOverlay::render);
    }

    public static void setupOpenGLDebugMessageCallback() {
        if (GL.getCapabilities().GL_KHR_debug) {
            GL43.glDebugMessageCallback((source, type, id, severity, length, message, userParam) -> {
                if (id == 1282 || id == 1281) {
                    return;
                }
                String errorMessage = GLDebugMessageCallback.getMessage((int)length, (long)message);
                Stellaris.LOG.error("OpenGL debug message: id={}, source={}, type={}, severity={}, message='{}'", new Object[]{id, source, type, severity, errorMessage});
            }, (long)0L);
            GL43.glEnable((int)37600);
            GL43.glEnable((int)33346);
        }
    }

    public static void registerPacks() {
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new StarPack());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new PlanetPack());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new MoonPack());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new TabletPack());
    }
}

