/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;

public class RocketBarOverlay {
    public static final ResourceLocation ROCKET = Stellaris.texture("planet_bar/rocket");

    public static void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getVehicle() instanceof RocketEntity || player.getVehicle() instanceof LanderEntity) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            double min = player.level().getMinBuildHeight();
            for (int i = player.level().getMinBuildHeight(); i < player.level().getMaxBuildHeight(); ++i) {
                if (level.getBlockState(new BlockPos(player.getBlockX(), i, player.getBlockZ())).getBlock() == Blocks.AIR) continue;
                min = i;
            }
            double yHeight = (player.getY() - min) / (600.0 - min) * 113.0;
            ResourceLocation planet = PlanetUtil.getPlanetBar(level.dimension().location());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)planet);
            graphics.blit(planet, 0, graphics.guiHeight() / 2 - 64, 0.0f, 0.0f, 16, 128, 16, 128);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ROCKET);
            ScreenHelper.renderWithFloat.blit(graphics.pose(), 4.0f, (float)((double)((float)graphics.guiHeight() / 2.0f + 51.5f) - yHeight), 0.0f, 0.0f, 8.0f, 11.0f, 8.0f, 11.0f);
        }
    }
}

