/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.menus.OxygenDistributorMenu;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OxygenDistributorScreen
extends AbstractContainerScreen<OxygenDistributorMenu> {
    private static final ResourceLocation TEXTURE = Stellaris.guiTexture("oxygen_distributor");
    private final OxygenDistributorBlockEntity blockEntity = ((OxygenDistributorMenu)this.getMenu()).getBlockEntity();
    private GaugeWidget energyGauge;
    private GaugeWidget oxygenGauge;

    public OxygenDistributorScreen(OxygenDistributorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 180;
        this.imageHeight = 188;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge = new GaugeWidget(this.leftPos + 67, this.topPos + 15, 46, 15, (Component)Component.translatable((String)"stellaris.screen.energyContainer"), GUISprites.SIDEWAYS_ENERGY_FULL, GUISprites.SIDEWAYS_BATTERY_OVERLAY, this.blockEntity.getEnergy(null).getMaxEnergy(), GaugeWidget.Direction4.LEFT_RIGHT);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
        SingleFluidStorage oxygenTank = this.blockEntity.oxygenTank;
        this.oxygenGauge = new GaugeWidget(this.leftPos + 64, this.topPos + 52, 16, 18, (Component)Component.translatable((String)"stellaris.screen.oxygen"), GUISprites.NO_OVERLAY, GUISprites.NO_OVERLAY, oxygenTank.getTankCapacity(0), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.oxygenGauge);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge.updateAmount(this.blockEntity.getEnergy(null).getEnergy());
        this.oxygenGauge.updateAmount(this.blockEntity.oxygenTank.getFluidValueInTank());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.oxygenGauge.renderTooltip(guiGraphics, x, y, this.font);
    }
}

