/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.InvisibleButton;
import com.st0x0ef.stellaris.client.screens.components.LaunchButton;
import com.st0x0ef.stellaris.client.screens.components.ModifiedButton;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.info.MoonInfo;
import com.st0x0ef.stellaris.client.screens.info.PlanetInfo;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.network.packets.TeleportEntityToPlanetPacket;
import com.st0x0ef.stellaris.common.registry.TranslatableRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWScrollCallback;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionScreen
extends AbstractContainerScreen<PlanetSelectionMenu> {
    public static final ResourceLocation HIGHLIGHTER_TEXTURE = Stellaris.guiTexture("util/planet_highlighter");
    public static final ResourceLocation BLACK_TEXTURE = Stellaris.guiTexture("util/black");
    public static final ResourceLocation BACKGROUND_TEXTURE = Stellaris.guiTexture("planet_selection");
    public static final ResourceLocation SCROLLER_TEXTURE = Stellaris.guiTexture("util/scroller");
    public static final ResourceLocation SMALL_BUTTON_TEXTURE = Stellaris.guiTexture("util/buttons/small_button");
    public static final ResourceLocation BUTTON_TEXTURE = Stellaris.guiTexture("util/buttons/button");
    public static final ResourceLocation LARGE_BUTTON_TEXTURE = Stellaris.guiTexture("util/buttons/large_button");
    public static final ResourceLocation LAUNCH_BUTTON_TEXTURE = Stellaris.guiTexture("util/buttons/launch_button");
    public static final ResourceLocation LAUNCH_BUTTON_HOVER_TEXTURE = Stellaris.guiTexture("util/buttons/launch_button_hovered");
    public static final ResourceLocation SMALL_MENU_LIST = Stellaris.guiTexture("util/planet_menu");
    public static final ResourceLocation LARGE_MENU_TEXTURE = Stellaris.guiTexture("util/large_planet_menu");
    public static final ResourceLocation LARGE_MENU_TEXTURE_RED = Stellaris.guiTexture("util/large_planet_menu_red");
    public static final List<CelestialBody> STARS = new ArrayList<CelestialBody>();
    public static final List<PlanetInfo> PLANETS = new ArrayList<PlanetInfo>();
    public static final List<MoonInfo> MOONS = new ArrayList<MoonInfo>();
    public static final Component temperature = Component.translatable((String)"text.stellaris.planetscreen.temperature");
    public static final Component gravity = Component.translatable((String)"text.stellaris.planetscreen.gravity");
    public static final Component launch = Component.translatable((String)"text.stellaris.planetscreen.launch");
    public static final Component oxygen = Component.translatable((String)"text.stellaris.planetscreen.oxygen");
    public static final Component system = Component.translatable((String)"text.stellaris.planetscreen.system");
    public static final Component error_message = Component.translatable((String)"text.stellaris.planetscreen.error_message");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final long UPDATE_INTERVAL = 1L;
    public static final Player p = Minecraft.getInstance().player;
    private boolean isLaunching = false;
    private boolean showLargeMenu = false;
    private boolean showHelpMenu = true;
    LaunchButton launchButton;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double lastMouseX;
    private double lastMouseY;
    private boolean dragging = false;
    private boolean isPausePressed = false;
    private boolean isShiftPressed = false;
    private boolean isWheelButtonDown = false;
    public boolean isPlanetScreenOpened;
    private double zoomLevel = 1.0;
    private GLFWScrollCallback prevScrollCallback;
    private final List<InvisibleButton> planetButtons = new ArrayList<InvisibleButton>();
    private final List<InvisibleButton> moonButtons = new ArrayList<InvisibleButton>();
    public static CelestialBody focusedBody = null;
    public static CelestialBody hoveredBody = null;
    private int currentHighlighterFrame = 0;
    private final int totalHighlighterFrames = 30;
    double angle;

    public PlanetSelectionScreen(PlanetSelectionMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.imageWidth = 1200;
        this.imageHeight = 1600;
        this.inventoryLabelY = this.imageHeight - 110;
    }

    protected void init() {
        super.init();
        this.getMenu().freeze_gui = false;
        this.centerSun();
        this.isPlanetScreenOpened = true;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        long windowHandle = Minecraft.getInstance().getWindow().getWindow();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, this::onMouseScroll);
        this.initializeAllButtons();
    }

    public boolean canLaunch(Planet planet) {
        if (this.getMenu().getForceCanGoTo()) {
            return true;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle instanceof RocketEntity) {
            RocketEntity rocket = (RocketEntity)vehicle;
            if (PlanetUtil.isPlanet(player.level().dimension().location())) {
                return rocket.canGoTo(PlanetUtil.getPlanet(player.level().dimension().location()), planet);
            }
            return rocket.canGoTo(PlanetUtil.getPlanet(Level.OVERWORLD.location()), planet);
        }
        return false;
    }

    private void initializeAllButtons() {
        this.initializePlanetButtons();
        this.initializeMoonButtons();
        this.initializeLaunchButton();
    }

    private void initializePlanetButtons() {
        this.planetButtons.clear();
        for (PlanetInfo planet : PLANETS) {
            int planetWidth = (int)((double)planet.width * this.zoomLevel);
            int planetHeight = (int)((double)planet.height * this.zoomLevel);
            float planetX = (float)(((double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle) - (double)planetWidth / 2.0) * this.zoomLevel);
            float planetY = (float)(((double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle) - (double)planetHeight / 2.0) * this.zoomLevel);
            InvisibleButton button = new InvisibleButton((int)planetX, (int)planetY, planetWidth + 2, planetHeight + 2, (Component)Component.literal((String)planet.name), btn -> this.onPlanetButtonClick(planet), () -> {
                hoveredBody = planet;
            });
            this.planetButtons.add(button);
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void updatePlanetsButton(int offsetX, int offsetY) {
        for (InvisibleButton button : this.planetButtons) {
            button.setX(button.getX() - offsetX);
            button.setY(button.getX() - offsetY);
        }
    }

    private void initializeMoonButtons() {
        this.moonButtons.clear();
        for (MoonInfo moon : MOONS) {
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            float moonX = (float)(((double)moon.orbitCenter.x + this.offsetX + moon.orbitRadius * Math.cos(moon.currentAngle) - (double)moonWidth / 2.0) * this.zoomLevel);
            float moonY = (float)(((double)moon.orbitCenter.y + this.offsetY + moon.orbitRadius * Math.sin(moon.currentAngle) - (double)moonHeight / 2.0) * this.zoomLevel);
            InvisibleButton button = new InvisibleButton((int)moonX, (int)moonY, moonWidth, moonHeight, (Component)Component.literal((String)moon.name), btn -> this.onMoonButtonClick(moon), () -> {
                hoveredBody = moon;
            });
            this.moonButtons.add(button);
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void initializeLaunchButton() {
        int buttonWidth = 74;
        int buttonHeight = 20;
        int buttonX = (this.width - buttonWidth) / 4 + 100;
        int buttonY = (this.height - buttonHeight) / 4;
        this.launchButton = new LaunchButton(buttonX, buttonY, buttonWidth, buttonHeight, launch, btn -> this.onLaunchButtonClick());
        this.launchButton.setButtonTexture(LAUNCH_BUTTON_TEXTURE, LAUNCH_BUTTON_HOVER_TEXTURE);
        this.addRenderableWidget((GuiEventListener)this.launchButton);
        this.launchButton.visible = false;
    }

    private void onPlanetButtonClick(PlanetInfo planet) {
        if (!this.showLargeMenu) {
            focusedBody = planet;
            this.centerOnBody(planet);
            this.showLargeMenu = true;
        }
    }

    private void onMoonButtonClick(MoonInfo moon) {
        if (!this.showLargeMenu && moon.clickable) {
            focusedBody = moon;
            this.centerOnBody(moon);
            this.showLargeMenu = true;
        }
    }

    private void onLaunchButtonClick() {
        if (focusedBody != null && PlanetSelectionScreen.focusedBody.dimension != null) {
            if (this.canLaunch(PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension))) {
                this.tpToFocusedPlanet();
            } else if (PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension).name().equals("Earth")) {
                this.tpToFocusedPlanet();
            }
            this.showLargeMenu = false;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(graphics, partialTicks, mouseX, mouseY);
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (!this.isPausePressed) {
            this.updatePlanets();
        }
        if (focusedBody != null) {
            this.centerOnBody(focusedBody);
        }
        if (!this.showLargeMenu) {
            this.launchButton.visible = false;
        }
        this.renderHelp(graphics);
        this.drawOrbits();
        this.renderBodiesAndPlanets(graphics);
        this.renderHighlighter(graphics, mouseX, mouseY);
        if (hoveredBody != null) {
            this.updateHighlighterPosition(graphics, hoveredBody);
        }
        if (focusedBody != null) {
            this.updateHighlighterPosition(graphics, focusedBody);
        }
        this.renderLargeMenu(graphics);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        graphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public void renderBodiesAndPlanets(GuiGraphics graphics) {
        this.renderStars(graphics);
        this.renderPlanets(graphics);
        this.renderMoons(graphics);
        this.initializePlanetButtons();
        this.initializeMoonButtons();
    }

    private void renderHelp(GuiGraphics graphics) {
        if (this.showHelpMenu) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"text.stellaris.planetscreen.press_space"), this.width / 2, this.height - 20, 0xFFFFFC);
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"text.stellaris.planetscreen.arrows"), this.width / 2, this.height - 10, 0xFFFFFC);
        }
    }

    private void renderStars(GuiGraphics graphics) {
        Font font = Minecraft.getInstance().font;
        for (CelestialBody star : STARS) {
            float bodyX = (float)(((double)star.x + this.offsetX) * this.zoomLevel - (double)(star.width / 2.0f) * this.zoomLevel);
            float bodyY = (float)(((double)star.y + this.offsetY) * this.zoomLevel - (double)(star.height / 2.0f) * this.zoomLevel);
            int bodyWidth = (int)((double)star.width * this.zoomLevel);
            int bodyHeight = (int)((double)star.height * this.zoomLevel);
            graphics.blit(star.texture, (int)bodyX, (int)bodyY, 0.0f, 0.0f, bodyWidth, bodyHeight, bodyWidth, bodyHeight);
            int nameWidth = font.width((FormattedText)star.getTranslatable());
            graphics.drawString(font, star.getTranslatable(), (int)(bodyX + (float)bodyWidth / 2.0f - (float)nameWidth / 2.0f), (int)(bodyY + (float)bodyHeight), 0xFFFFFF);
        }
    }

    private void renderPlanets(GuiGraphics graphics) {
        Font font = Minecraft.getInstance().font;
        for (PlanetInfo planet : PLANETS) {
            CelestialBody orbitCenter = planet.orbitCenter;
            float orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            float orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            float planetX = (float)((double)orbitCenterX + planet.orbitRadius * this.zoomLevel * Math.cos(planet.currentAngle) - (double)(planet.width / 2.0f) * this.zoomLevel);
            float planetY = (float)((double)orbitCenterY + planet.orbitRadius * this.zoomLevel * Math.sin(planet.currentAngle) - (double)(planet.height / 2.0f) * this.zoomLevel);
            int planetWidth = (int)((double)planet.width * this.zoomLevel);
            int planetHeight = (int)((double)planet.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, planet.texture, (int)planetX, (int)planetY, 0, 0, planetWidth, planetHeight, planetWidth, planetHeight, (float)planet.currentAngle);
            int nameWidth = font.width((FormattedText)planet.getTranslatable());
            graphics.drawString(font, planet.getTranslatable(), (int)(planetX + (float)planetWidth / 2.0f - (float)nameWidth / 2.0f), (int)(planetY + (float)planetHeight), 0xFFFFFF);
        }
    }

    private void renderMoons(GuiGraphics graphics) {
        for (MoonInfo moon : MOONS) {
            float moonX = (float)(((double)moon.x + this.offsetX) * this.zoomLevel - (double)(moon.width / 2.0f) * this.zoomLevel);
            float moonY = (float)(((double)moon.y + this.offsetY) * this.zoomLevel - (double)(moon.height / 2.0f) * this.zoomLevel);
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, moon.texture, (int)moonX, (int)moonY, 0, 0, moonWidth, moonHeight, moonWidth, moonHeight, (float)moon.currentAngle);
        }
    }

    private void renderHighlighter(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!(this.showLargeMenu || hoveredBody == null && focusedBody == null)) {
            CelestialBody bodyToHighlight = hoveredBody != null ? hoveredBody : focusedBody;
            this.renderBodyDescription(graphics, bodyToHighlight, mouseX, mouseY);
            this.renderHighlightFrame(graphics, bodyToHighlight);
        }
    }

    private void renderBodyDescription(GuiGraphics graphics, CelestialBody bodyToHighlight, int mouseX, int mouseY) {
        ArrayList<Component> bodyDescription = new ArrayList<Component>();
        bodyDescription.add(Utils.getMessageComponent("\u00a7f" + bodyToHighlight.getTranslatable().getString()));
        if (!this.isShiftPressed) {
            bodyDescription.add(Utils.getMessageComponent("\u00a78" + TranslatableRegistry.HOLD_SHIFT.getString()));
        } else {
            this.addDetailedDescription(bodyDescription, bodyToHighlight);
        }
        if (this.isPausePressed) {
            graphics.renderComponentTooltip(this.font, bodyDescription, mouseX, mouseY);
        }
    }

    private void addDetailedDescription(List<Component> bodyDescription, CelestialBody bodyToHighlight) {
        bodyDescription.add(Utils.getMessageComponent("\u00a7f\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3"));
        Planet planet = PlanetUtil.getPlanet(bodyToHighlight.dimension);
        if (planet == null) {
            bodyDescription.add(Utils.getMessageComponent(error_message.getString(), "Red"));
        } else {
            bodyDescription.add(Utils.getMessageComponent(temperature.getString() + " : " + planet.temperature() + "\u00b0C"));
            bodyDescription.add(Utils.getMessageComponent(gravity.getString() + " : " + planet.gravity() + "m/s\u00b2"));
            bodyDescription.add(Utils.getMessageComponent(oxygen.getString() + " : " + planet.oxygen()));
            bodyDescription.add(Utils.getMessageComponent(system.getString() + " : " + Component.translatable((String)planet.system()).getString()));
            if (bodyToHighlight instanceof PlanetInfo && this.getMoonsCount((PlanetInfo)bodyToHighlight) > 0) {
                bodyDescription.add(Utils.getMessageComponent(""));
                bodyDescription.add(Utils.getMessageComponent(TranslatableRegistry.MOONS.getString() + " : " + this.getMoonsCount((PlanetInfo)bodyToHighlight)));
            }
            if (this.getPlayer().getServer() != null) {
                bodyDescription.add(Utils.getMessageComponent(""));
                bodyDescription.add(Utils.getMessageComponent(TranslatableRegistry.PLAYERS.getString() + " : " + Utils.getPlayerCountInDimension(this.getPlayer().getServer(), bodyToHighlight.dimension)));
            }
        }
    }

    private void renderHighlightFrame(GuiGraphics graphics, CelestialBody bodyToHighlight) {
        int highlightWidth = (int)((double)bodyToHighlight.width * this.zoomLevel);
        int highlightHeight = (int)((double)bodyToHighlight.height * this.zoomLevel);
        float highlightX = (float)(((double)bodyToHighlight.x + this.offsetX) * this.zoomLevel - (double)highlightWidth / 2.0);
        float highlightY = (float)(((double)bodyToHighlight.y + this.offsetY) * this.zoomLevel - (double)highlightHeight / 2.0);
        this.currentHighlighterFrame = (this.currentHighlighterFrame + 1) % 30;
        int frameY = this.currentHighlighterFrame * highlightHeight;
        float currentAngle = bodyToHighlight instanceof PlanetInfo ? (float)((PlanetInfo)bodyToHighlight).currentAngle : (float)((MoonInfo)bodyToHighlight).currentAngle;
        ScreenHelper.drawTexturewithRotation(graphics, HIGHLIGHTER_TEXTURE, (int)highlightX, (int)highlightY, 0, frameY, highlightWidth, highlightHeight, highlightWidth, 30 * highlightHeight, currentAngle);
    }

    private void renderLargeMenu(GuiGraphics graphics) {
        if (this.showLargeMenu) {
            MutableComponent systemV;
            this.getMenu().freeze_gui = false;
            ResourceLocation CELESTIAL_BODY_TEXTURE = PlanetSelectionScreen.focusedBody.texture;
            Component CELESTIAL_BODY_NAME = focusedBody.getTranslatable();
            Planet planet = PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension);
            if (planet == null) {
                return;
            }
            float CELESTIAL_BODY_TEMPERATURE = planet.temperature();
            float CELESTIAL_BODY_GRAVITY = planet.gravity();
            boolean CELESTIAL_BODY_OXYGEN = planet.oxygen();
            String CELESTIAL_BODY_SYSTEM = planet.system();
            if (CELESTIAL_BODY_SYSTEM == null) {
                systemV = Component.literal((String)(String.valueOf(system) + " : null"));
            } else {
                MutableComponent systemTranslatable = Component.translatable((String)CELESTIAL_BODY_SYSTEM);
                systemV = Component.literal((String)(system.getString() + " : " + systemTranslatable.getString()));
            }
            MutableComponent temperatureV = Component.literal((String)(temperature.getString() + " : " + planet.temperature() + "\u00b0C"));
            MutableComponent oxygenV = Component.literal((String)(oxygen.getString() + " : " + CELESTIAL_BODY_OXYGEN));
            MutableComponent gravityV = Component.literal((String)(gravity.getString() + " : " + CELESTIAL_BODY_GRAVITY + "m/s"));
            int oxygenColor = CELESTIAL_BODY_OXYGEN ? Utils.getColorHexCode("Lime") : Utils.getColorHexCode("Red");
            int temperatureColor = CELESTIAL_BODY_TEMPERATURE >= 100.0f ? Utils.getColorHexCode("DarkRed") : (CELESTIAL_BODY_TEMPERATURE >= 0.0f ? Utils.getColorHexCode("Lime") : (CELESTIAL_BODY_TEMPERATURE >= -100.0f ? Utils.getColorHexCode("Cyan") : Utils.getColorHexCode("Blue")));
            int menuWidth = 215;
            int menuHeight = 177;
            int buttonWidth = 74;
            int buttonHeight = 20;
            int centerX = (this.width - menuWidth) / 2;
            int centerY = (this.height - menuHeight) / 2;
            int buttonX = centerX + buttonWidth / 2 - buttonWidth / 3 - buttonWidth / 15;
            int buttonY = centerY + buttonHeight / 2 + 1;
            int textX = buttonX + buttonWidth / 4 - 20;
            this.launchButton.visible = true;
            this.launchButton.setPosition(buttonX, buttonY);
            float alpha = 0.5f;
            RenderSystem.disableBlend();
            graphics.drawString(this.font, CELESTIAL_BODY_NAME, textX, buttonY + buttonHeight / 4 + 37, 0xFFFFFF, true);
            graphics.drawString(this.font, "\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3", textX, buttonY + buttonHeight / 4 + 50, 0xFFFFFF, true);
            graphics.drawString(this.font, (Component)temperatureV, textX, buttonY + buttonHeight / 4 + 60, temperatureColor, true);
            graphics.drawString(this.font, (Component)oxygenV, textX, buttonY + buttonHeight / 4 + 90, oxygenColor, true);
            graphics.drawString(this.font, (Component)systemV, textX, buttonY + buttonHeight / 4 + 105, 0xFFFFFF, true);
            if (focusedBody instanceof PlanetInfo && this.getMoonsCount((PlanetInfo)focusedBody) > 0) {
                graphics.drawString(this.font, TranslatableRegistry.MOONS.getString() + " : " + this.getMoonsCount((PlanetInfo)focusedBody), textX, buttonY + buttonHeight / 4 + 120, 0xD3D3D3, true);
            }
            if (this.getPlayer().getServer() != null) {
                graphics.drawString(this.font, TranslatableRegistry.PLAYERS.getString() + " : " + Utils.getPlayerCountInDimension(this.getPlayer().getServer(), PlanetSelectionScreen.focusedBody.dimension), textX, buttonY + buttonHeight / 4 + 135, 0xFFFFFF, false);
            }
            if (this.canLaunch(planet)) {
                graphics.drawString(this.font, (Component)gravityV, textX, buttonY + buttonHeight / 4 + 75, Utils.getColorHexCode("White"), true);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LARGE_MENU_TEXTURE);
                graphics.blit(LARGE_MENU_TEXTURE, centerX, centerY, 0.0f, 0.0f, menuWidth, menuHeight, menuWidth, menuHeight);
                this.launchButton.setButtonTexture(Stellaris.guiTexture("util/buttons/launch_button"), Stellaris.guiTexture("util/buttons/launch_button_hovered"));
            } else if (Objects.equals(PlanetSelectionScreen.focusedBody.name, "Earth")) {
                graphics.drawString(this.font, (Component)gravityV, textX, buttonY + buttonHeight / 4 + 75, Utils.getColorHexCode("White"), true);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LARGE_MENU_TEXTURE);
                this.launchButton.setButtonTexture(Stellaris.guiTexture("util/buttons/launch_button"), Stellaris.guiTexture("util/buttons/launch_button_hovered"));
                graphics.blit(LARGE_MENU_TEXTURE, centerX, centerY, 0.0f, 0.0f, menuWidth, menuHeight, menuWidth, menuHeight);
            } else {
                graphics.drawString(this.font, (Component)gravityV, textX, buttonY + buttonHeight / 4 + 75, Utils.getColorHexCode("Orange"), true);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LARGE_MENU_TEXTURE_RED);
                graphics.blit(LARGE_MENU_TEXTURE_RED, centerX, centerY, 0.0f, 0.0f, menuWidth, menuHeight, menuWidth, menuHeight);
                this.launchButton.setButtonTexture(Stellaris.guiTexture("util/buttons/no_launch_button"), Stellaris.guiTexture("util/buttons/no_launch_button_hovered"));
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BLACK_TEXTURE);
            graphics.blit(BLACK_TEXTURE, centerX + menuWidth - 64, centerY + menuHeight / 2 - 32, 0.0f, 0.0f, 48, 48, 48, 48);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CELESTIAL_BODY_TEXTURE);
            if (PlanetSelectionScreen.focusedBody.width != PlanetSelectionScreen.focusedBody.height) {
                if ((float)Math.min((int)PlanetSelectionScreen.focusedBody.width, (int)PlanetSelectionScreen.focusedBody.height) == PlanetSelectionScreen.focusedBody.width) {
                    float rate = PlanetSelectionScreen.focusedBody.height / PlanetSelectionScreen.focusedBody.width;
                    graphics.blit(CELESTIAL_BODY_TEXTURE, centerX + menuWidth - 46, centerY + menuHeight / 2 - 14, 0.0f, 0.0f, 12, (int)(12.0f * rate), 12, (int)(12.0f * rate));
                } else {
                    float rate = PlanetSelectionScreen.focusedBody.width / PlanetSelectionScreen.focusedBody.height;
                    graphics.blit(CELESTIAL_BODY_TEXTURE, centerX + menuWidth - 46, centerY + menuHeight / 2 - 14, 0.0f, 0.0f, (int)(12.0f * rate), 12, (int)(12.0f * rate), 12);
                }
            } else {
                graphics.blit(CELESTIAL_BODY_TEXTURE, centerX + menuWidth - 46, centerY + menuHeight / 2 - 14, 0.0f, 0.0f, 12, 12, 12, 12);
            }
            RenderSystem.disableBlend();
        } else {
            this.launchButton.visible = false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 90) {
            if (focusedBody != null && this.canLaunch(PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension))) {
                this.tpToFocusedPlanet();
            }
        } else if (keyCode == 72) {
            this.showHelpMenu = !this.showHelpMenu;
        } else if (keyCode == 32) {
            this.isPausePressed = !this.isPausePressed;
        } else if (keyCode == 340 || keyCode == 344) {
            this.isShiftPressed = true;
        } else if (keyCode == 262) {
            if (focusedBody instanceof CelestialBody) {
                focusedBody = this.getNextBodyByDistance(focusedBody);
                this.centerOnBody(focusedBody);
            }
        } else if (keyCode == 263) {
            if (focusedBody instanceof CelestialBody) {
                focusedBody = this.getPreviousBodyByDistance(focusedBody);
                this.centerOnBody(focusedBody);
            }
        } else if (keyCode == 264) {
            if (focusedBody instanceof PlanetInfo) {
                CelestialBody moonToBeFocused = this.getMoonsByDistance((PlanetInfo)focusedBody);
                if (moonToBeFocused.clickable) {
                    focusedBody = moonToBeFocused;
                    this.centerOnBody(focusedBody);
                }
            }
        } else if (keyCode == 265 && focusedBody instanceof MoonInfo) {
            focusedBody = ((MoonInfo)PlanetSelectionScreen.focusedBody).orbitCenter;
            this.centerOnBody(focusedBody);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private CelestialBody getNextBodyByDistance(CelestialBody currentBody) {
        CelestialBody celestialBody = currentBody;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlanetInfo.class, MoonInfo.class}, (Object)celestialBody, n)) {
            case -1: {
                return null;
            }
            case 0: {
                PlanetInfo planetInfo = (PlanetInfo)celestialBody;
                ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = 0; i < bodies.size(); ++i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i + 1; j < bodies.size(); ++j) {
                        if (((PlanetInfo)bodies.get((int)j)).orbitCenter != ((PlanetInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
            case 1: {
                MoonInfo moonInfo = (MoonInfo)celestialBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = 0; i < bodies.size(); ++i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i + 1; j < bodies.size(); ++j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != ((MoonInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
        }
        return currentBody;
    }

    private CelestialBody getPreviousBodyByDistance(CelestialBody currentBody) {
        CelestialBody celestialBody = currentBody;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlanetInfo.class, MoonInfo.class}, (Object)celestialBody, n)) {
            case -1: {
                return null;
            }
            case 0: {
                PlanetInfo planetInfo = (PlanetInfo)celestialBody;
                ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = bodies.size() - 1; i >= 0; --i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i - 1; j >= 0; --j) {
                        if (((PlanetInfo)bodies.get((int)j)).orbitCenter != ((PlanetInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
            case 1: {
                MoonInfo moonInfo = (MoonInfo)celestialBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = bodies.size() - 1; i >= 0; --i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i - 1; j >= 0; --j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != ((MoonInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
        }
        return currentBody;
    }

    private CelestialBody getMoonsByDistance(PlanetInfo currentBody) {
        CelestialBody smallestOrbitMoon = null;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody) || smallestOrbitMoon != null && !(moon.orbitRadius < ((MoonInfo)smallestOrbitMoon).orbitRadius)) continue;
            smallestOrbitMoon = moon;
        }
        return smallestOrbitMoon != null ? smallestOrbitMoon : currentBody;
    }

    private int getMoonsCount(PlanetInfo currentBody) {
        int i = 0;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody)) continue;
            ++i;
        }
        return i;
    }

    public void tpToFocusedPlanet() {
        if (focusedBody != null) {
            NetworkManager.sendToServer((CustomPacketPayload)new TeleportEntityToPlanetPacket(PlanetSelectionScreen.focusedBody.dimension));
            long windowHandle = Minecraft.getInstance().getWindow().getWindow();
            this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((MouseHandler)Minecraft.getInstance().mouseHandler).onScroll(arg_0, arg_1, arg_2));
        } else {
            Stellaris.LOG.error("Focused body is null");
        }
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            this.isShiftPressed = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    private void updatePlanets() {
        long time = Util.getMillis();
        if (!this.getMenu().freeze_gui || !this.isPausePressed) {
            for (PlanetInfo planet : PLANETS) {
                planet.updateAngle(time);
                planet.updatePosition();
                this.angle = planet.updateAngle(time);
            }
            for (MoonInfo moon : MOONS) {
                moon.updateAngle(time);
                moon.updatePosition();
                this.angle = moon.updateAngle(time);
            }
        }
    }

    public void drawOrbits() {
        float orbitCenterY;
        float orbitCenterX;
        CelestialBody orbitCenter;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        for (PlanetInfo planet : PLANETS) {
            orbitCenter = planet.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(tesselator, orbitCenterX, orbitCenterY, planet.orbitRadius * this.zoomLevel, 75, orbitCenter.orbitColor, 1.0f);
        }
        for (MoonInfo moon : MOONS) {
            orbitCenter = moon.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(tesselator, orbitCenterX, orbitCenterY, moon.orbitRadius * this.zoomLevel, 75, 0x888888, 0.5f);
        }
        RenderSystem.disableBlend();
    }

    public static void renderOrbits(Tesselator tesselator, double centerX, double centerY, double radius, int sides, int color, float alphaL) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float angleStep = (float)(Math.PI * 2 / (double)sides);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i < sides; ++i) {
            float currentAngle = (float)i * angleStep;
            float nextAngle = currentAngle + angleStep;
            float vertex1X = (float)(centerX + radius * Math.cos(currentAngle));
            float vertex1Y = (float)(centerY + radius * Math.sin(currentAngle));
            float vertex2X = (float)(centerX + radius * Math.cos(nextAngle));
            float vertex2Y = (float)(centerY + radius * Math.sin(nextAngle));
            bufferBuilder.addVertex(vertex1X, vertex1Y, 0.0f).setColor(red, green, blue, alphaL);
            bufferBuilder.addVertex(vertex2X, vertex2Y, 0.0f).setColor(red, green, blue, alphaL);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    private void centerSun() {
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        CelestialBody sun = PlanetSelectionScreen.findByNameStar("stellaris:sun");
        if (sun != null) {
            sun.setPosition(centerX, centerY);
        } else {
            Stellaris.LOG.error("stellaris:sun is null");
        }
        this.offsetX = 0.0;
        this.offsetY = 0.0;
    }

    public static CelestialBody findByNameStar(String id) {
        for (CelestialBody body : STARS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        Stellaris.LOG.warn("Star not found : {}", (Object)id);
        return null;
    }

    public static PlanetInfo findByNamePlanet(String id) {
        for (PlanetInfo body : PLANETS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    public static MoonInfo findByNameMoon(String id) {
        for (MoonInfo body : MOONS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    private void centerOnBody(CelestialBody body) {
        this.zoomLevel = this.isLaunching ? 1.6 : 1.0;
        this.offsetX = ((double)body.x - (double)this.width / 2.0) * -1.0;
        this.offsetY = ((double)body.y - (double)this.height / 2.0) * -1.0;
    }

    private void onMouseScroll(long window, double scrollX, double scrollY) {
        double[] mouseX = new double[1];
        double[] mouseY = new double[1];
        GLFW.glfwGetCursorPos((long)window, (double[])mouseX, (double[])mouseY);
        if (this.minecraft != null && this.minecraft.player != null) {
            CreativeModeInventoryScreen creativeScreen;
            Screen screen;
            if (this.minecraft.screen != null) {
                this.handleHotbarScroll(scrollY);
            }
            if ((screen = this.minecraft.screen) instanceof CreativeModeInventoryScreen && (creativeScreen = (CreativeModeInventoryScreen)screen).mouseScrolled(mouseX[0], mouseY[0], scrollX, scrollY)) {
                return;
            }
            if (this.minecraft.screen instanceof PlanetSelectionScreen && scrollY != 0.0) {
                for (int i = 0; i < 5; ++i) {
                    this.zoomLevel += scrollY * 0.004;
                }
                this.zoomLevel = Math.max(0.02, Math.min(this.zoomLevel, 2.0));
            }
        }
    }

    private boolean handleHotbarScroll(double scrollY) {
        if (this.minecraft != null && this.minecraft.player != null) {
            int currentSlot = this.minecraft.player.getInventory().selected;
            int newSlot = currentSlot - (int)scrollY;
            if ((newSlot = (newSlot + 9) % 9) != currentSlot) {
                this.minecraft.player.getInventory().selected = newSlot;
                return true;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 2) {
            this.isWheelButtonDown = true;
        }
        if (button == 0 || button == 1) {
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (this.showLargeMenu) {
                if (this.launchButton.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
                this.showLargeMenu = false;
                return true;
            }
            focusedBody = null;
            hoveredBody = null;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.dragging = false;
        }
        if (button == 2) {
            this.isWheelButtonDown = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            if (this.isWheelButtonDown) {
                double rotationSpeed = 0.005;
                double deltaAngle = deltaX * rotationSpeed;
                for (PlanetInfo planet : PLANETS) {
                    planet.currentAngle += deltaAngle;
                    planet.updatePosition();
                }
                for (MoonInfo moon : MOONS) {
                    moon.currentAngle += deltaAngle;
                    moon.updatePosition();
                }
            } else {
                this.offsetX += Utils.changeLastDigitToEven((mouseX - this.lastMouseX) / this.zoomLevel);
                this.offsetY += Utils.changeLastDigitToEven((mouseY - this.lastMouseY) / this.zoomLevel);
                this.updatePlanetsButton((int)this.offsetX, (int)this.offsetY);
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void updateHighlighterPosition(GuiGraphics graphics, CelestialBody body) {
        int highlightWidth = (int)((double)body.width * this.zoomLevel);
        int highlightHeight = (int)((double)body.height * this.zoomLevel);
        float highlightX = (float)(((double)body.x + this.offsetX) * this.zoomLevel - (double)highlightWidth / 2.0);
        float highlightY = (float)(((double)body.y + this.offsetY) * this.zoomLevel - (double)highlightHeight / 2.0);
        this.currentHighlighterFrame = (this.currentHighlighterFrame + 1) % 30;
        int frameY = this.currentHighlighterFrame * highlightHeight;
        float currentAngle = body instanceof PlanetInfo ? (float)((PlanetInfo)body).currentAngle : (float)((MoonInfo)body).currentAngle;
        ScreenHelper.drawTexturewithRotation(graphics, HIGHLIGHTER_TEXTURE, (int)highlightX, (int)highlightY, 0, frameY, highlightWidth, highlightHeight, highlightWidth, 30 * highlightHeight, currentAngle);
    }

    public PlanetSelectionMenu getMenu() {
        return (PlanetSelectionMenu)this.menu;
    }

    public void onClose() {
        if (this.getPlayer().stellaris$isPlanetMenuOpen()) {
            return;
        }
        long windowHandle = Minecraft.getInstance().getWindow().getWindow();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((MouseHandler)Minecraft.getInstance().mouseHandler).onScroll(arg_0, arg_1, arg_2));
        super.onClose();
    }

    public Player getPlayer() {
        return ((PlanetSelectionMenu)this.menu).getPlayer();
    }

    public ModifiedButton addButton(int x, int y, int row, int width, int height, boolean rocketCondition, ModifiedButton.ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, Component title, Button.OnPress onPress) {
        return (ModifiedButton)this.addRenderableWidget((GuiEventListener)new ModifiedButton(x, y, row, width, height, 0, 0, 0, rocketCondition, type, list, buttonTexture, colorType, width, height, onPress, title));
    }
}

