/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WaterPumpBlockEntity;
import com.st0x0ef.stellaris.common.menus.WaterPumpMenu;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WaterPumpScreen
extends AbstractContainerScreen<WaterPumpMenu> {
    public static final ResourceLocation TEXTURE = Stellaris.guiTexture("water_pump");
    private final WaterPumpBlockEntity blockEntity = ((WaterPumpMenu)this.getMenu()).getBlockEntity();
    private GaugeWidget waterTankGauge;
    private GaugeWidget energyGauge;

    public WaterPumpScreen(WaterPumpMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        SingleFluidStorage waterTank = this.blockEntity.getWaterTank();
        this.waterTankGauge = new GaugeWidget(this.leftPos + 25, this.topPos + 20, 12, 42, (Component)Component.translatable((String)"stellaris.screen.water"), GUISprites.WATER_OVERLAY, GUISprites.LIQUID_TANK_OVERLAY, waterTank.getTankCapacity(waterTank.getTanks()) - 1L, GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.waterTankGauge);
        this.energyGauge = new GaugeWidget(this.leftPos + 150, this.topPos + 20, 13, 46, (Component)Component.translatable((String)"stellaris.screen.energyContainer"), GUISprites.ENERGY_FULL, GUISprites.BATTERY_OVERLAY_OLD, this.blockEntity.getEnergy(null).getMaxEnergy(), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.waterTankGauge.updateAmount((int)this.blockEntity.getWaterTank().getFluidValueInTank());
        this.energyGauge.updateAmount(this.blockEntity.getEnergy(null).getEnergy());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.waterTankGauge != null) {
            this.waterTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        }
        if (this.energyGauge != null) {
            this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
        }
    }
}

