/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GaugeWidget
extends AbstractWidget {
    protected long capacity;
    protected long amount = 0L;
    protected ResourceLocation sprite;
    protected ResourceLocation overlay_sprite;
    protected final Direction4 DIRECTION;

    public GaugeWidget(int x, int y, int width, int height, Component message, ResourceLocation sprite, @Nullable ResourceLocation overlay_sprite, long capacity, Direction4 direction) {
        super(x, y, width, height, message);
        this.sprite = sprite;
        this.overlay_sprite = overlay_sprite;
        this.capacity = capacity;
        this.DIRECTION = direction;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        switch (this.DIRECTION.ordinal()) {
            case 0: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getHeight() - 1)));
                guiGraphics.blitSprite(this.sprite, this.getWidth(), this.getHeight(), 0, this.getHeight() - i, this.getX(), this.getY() + this.getHeight() - i, this.getWidth(), i);
                break;
            }
            case 1: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getHeight() - 1)));
                guiGraphics.blitSprite(this.sprite, this.getWidth(), this.getHeight(), 0, 0, this.getX(), this.getY(), this.getWidth(), i);
                break;
            }
            case 2: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getWidth() - 1)));
                guiGraphics.blitSprite(this.sprite, this.getWidth(), this.getHeight(), 0, 0, this.getX(), this.getY(), i, this.getHeight());
                break;
            }
            case 3: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getWidth() - 1)));
                guiGraphics.blitSprite(this.sprite, this.getWidth(), this.getHeight(), this.getWidth() - i, 0, this.getX() + this.getWidth() - i, this.getY(), i, this.getHeight());
            }
        }
        if (this.overlay_sprite != null) {
            guiGraphics.blitSprite(this.overlay_sprite, this.getX(), this.getY(), this.width, this.height);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, Font font) {
        this.renderTooltips(graphics, mouseX, mouseY, font, list -> {});
    }

    public void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY, Font font, Consumer<List<Component>> components) {
        String GaugeComponent = this.getMessage().getString() + " : " + this.amount + " / " + this.capacity;
        Component capacity = this.amount >= this.capacity ? Utils.getMessageComponent(GaugeComponent, "Lime") : (this.amount <= 0L ? Utils.getMessageComponent(GaugeComponent, "Red") : Utils.getMessageComponent(GaugeComponent, "Orange"));
        ArrayList<Component> components1 = new ArrayList<Component>();
        components.accept(components1);
        components1.addFirst(capacity);
        if (mouseX >= this.getX() && mouseX <= this.getX() + this.width && mouseY >= this.getY() && mouseY <= this.getY() + this.height) {
            graphics.renderComponentTooltip(font, components1, mouseX, mouseY);
        }
    }

    public void updateAmount(long value) {
        this.amount = Math.clamp(value, 0L, this.capacity);
    }

    public void updateCapacity(long capacity) {
        this.capacity = capacity;
        this.amount = Math.min(this.amount, capacity);
    }

    public void updateSprite(ResourceLocation sprite) {
        this.sprite = sprite;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private double getProgress(Long amount, Long capacity) {
        return Mth.clamp((double)((double)amount.longValue() / (double)capacity.longValue()), (double)0.0, (double)1.0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public static enum Direction4 {
        DOWN_UP,
        UP_DOWN,
        LEFT_RIGHT,
        RIGHT_LEFT;

    }
}

