/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TexturedButton
extends Button {
    public static final ResourceLocation TEXTURE = Stellaris.guiTexture("util/buttons/button");
    public static final ResourceLocation HOVER_TEXTURE = Stellaris.guiTexture("util/buttons/button");
    private ResourceLocation buttonTexture;
    private ResourceLocation hoverButtonTexture;
    private int xTexStart;
    private int yTexStart;
    private int yDiffText;
    private int textureWidth;
    private int textureHeight;

    public TexturedButton(int xIn, int yIn, int widthIn, int heightIn, Button.OnPress onPressIn) {
        this(xIn, yIn, widthIn, heightIn, (Component)Component.empty(), onPressIn, DEFAULT_NARRATION);
    }

    public TexturedButton(int xIn, int yIn, int widthIn, int heightIn, Component title, Button.OnPress onPressIn) {
        this(xIn, yIn, widthIn, heightIn, title, onPressIn, DEFAULT_NARRATION);
    }

    public TexturedButton(int xIn, int yIn, int widthIn, int heightIn, Component title, Button.OnPress onPressIn, Button.CreateNarration onTooltipIn) {
        super(xIn, yIn, widthIn, heightIn, title, onPressIn, onTooltipIn);
        this.textureWidth = widthIn;
        this.textureHeight = heightIn;
        this.yDiffText = 0;
        this.xTexStart = 0;
        this.yTexStart = 0;
        this.buttonTexture = TEXTURE;
        this.hoverButtonTexture = HOVER_TEXTURE;
    }

    public <T extends TexturedButton> T tooltip(@Nullable Tooltip tooltip) {
        this.setTooltip(tooltip);
        return this.cast();
    }

    private <T extends TexturedButton> T cast() {
        return (T)((Object)this);
    }

    public <T extends TexturedButton> T tex(ResourceLocation buttonTexture, ResourceLocation hoverTexture) {
        this.buttonTexture = buttonTexture;
        this.hoverButtonTexture = hoverTexture;
        return this.cast();
    }

    public <T extends TexturedButton> T size(int texWidth, int texHeight) {
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
        return this.cast();
    }

    public <T extends TexturedButton> T setUVs(int xTexStart, int yTexStart) {
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        return this.cast();
    }

    public void setYShift(int y) {
        this.yDiffText = y;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        int i = this.yTexStart;
        if (this.isHoveredOrFocused()) {
            i += this.yDiffText;
        }
        ResourceLocation texture = this.getTypeTexture(this.isHovered, this.buttonTexture, this.hoverButtonTexture);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        ScreenHelper.renderTextureWithColor.blit(graphics.pose(), this.getX(), this.getY(), this.xTexStart, i, this.width, this.height, this.textureWidth, this.textureHeight, this.getTypeColor());
        Font fontRenderer = minecraft.font;
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    private ResourceLocation getTypeTexture(boolean hover, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture) {
        if (hover) {
            return hoverButtonTexture;
        }
        return buttonTexture;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.textureWidth = width;
        this.textureHeight = height;
    }

    protected Vec3 getTypeColor() {
        return ColorTypes.DEFAULT.getColor();
    }

    public static enum ColorTypes {
        DEFAULT(new Vec3(255.0, 255.0, 255.0)),
        WHITE(new Vec3(240.0, 240.0, 240.0)),
        ORANGE(new Vec3(235.0, 136.0, 68.0)),
        MAGENTA(new Vec3(195.0, 84.0, 205.0)),
        LIGHT_BLUE(new Vec3(102.0, 137.0, 211.0)),
        YELLOW(new Vec3(222.0, 207.0, 42.0)),
        LIME(new Vec3(65.0, 205.0, 52.0)),
        PINK(new Vec3(216.0, 129.0, 152.0)),
        GRAY(new Vec3(67.0, 67.0, 67.0)),
        LIGHT_GRAY(new Vec3(171.0, 171.0, 171.0)),
        CYAN(new Vec3(40.0, 118.0, 151.0)),
        PURPLE(new Vec3(123.0, 47.0, 190.0)),
        BLUE(new Vec3(37.0, 49.0, 146.0)),
        BROWN(new Vec3(81.0, 48.0, 26.0)),
        GREEN(new Vec3(53.0, 163.0, 79.0)),
        RED(new Vec3(179.0, 49.0, 44.0)),
        BLACK(new Vec3(30.0, 27.0, 27.0));

        private final Vec3 color;

        private ColorTypes(Vec3 color) {
            this.color = color;
        }

        public Vec3 getColor() {
            return this.color;
        }
    }
}

