/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.tablet;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.TabletButton;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntryWidget;
import com.st0x0ef.stellaris.client.screens.tablet.TabletMainScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TabletEntryScreen
extends Screen {
    private int leftPos;
    private int topPos;
    private int imageHeight;
    private int imageWidth;
    public static final ResourceLocation MENU_BACKGROUND_LIGHT = Stellaris.guiTexture("tablet/tablet_background_light");
    public static final ResourceLocation SMALL_BACK_ARROW = Stellaris.guiTexture("tablet/small_back_arrow");
    public static final ResourceLocation SMALL_NEXT_ARROW = Stellaris.guiTexture("tablet/small_next_arrow");
    public static final ResourceLocation SMALL_HOME_BUTTON = Stellaris.guiTexture("tablet/small_home_button");
    public static final ResourceLocation HOME_BUTTON = Stellaris.guiTexture("tablet/main_page");
    public static final ResourceLocation HOME_BUTTON_HOVER = Stellaris.guiTexture("tablet/main_page_hover");
    public static final ResourceLocation BACK_ARROW = Stellaris.guiTexture("tablet/back_page");
    public static final ResourceLocation BACK_ARROW_HOVER = Stellaris.guiTexture("tablet/back_page_hovered");
    public static final ResourceLocation NEXT_ARROW = Stellaris.guiTexture("tablet/next_page");
    public static final ResourceLocation NEXT_ARROW_HOVER = Stellaris.guiTexture("tablet/next_page_hovered");
    public static final ResourceLocation BUTTON_TEXTURE = Stellaris.guiTexture("tablet/button");
    public static final ResourceLocation BUTTON_HOVERED_TEXTURE = Stellaris.guiTexture("tablet/button_click");
    private final TabletMainScreen screen;
    public TabletEntry entry;
    private ArrayList<TabletButton> PAGES_BUTTONS = new ArrayList();
    public String currentPage = "main";
    public TexturedButton nextButton;
    public TexturedButton backButton;
    public TabletEntryWidget widget;
    public TexturedButton homeButton;
    public ArrayList<ArrayList<TabletButton>> ENTRY_BUTTONS = new ArrayList();
    public int currentEntryPage = 0;

    protected TabletEntryScreen(Component title, TabletMainScreen screen, int leftPos, int topPos, TabletEntry entry) {
        super(title);
        this.screen = screen;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.entry = entry;
        this.imageHeight = 162;
        this.imageWidth = 250;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.currentPage.equals("main")) {
            guiGraphics.drawCenteredString(this.font, this.title.getString().toUpperCase(), this.width / 2, this.topPos + 20, 0xFFFFFF);
            this.showEntryButton();
            this.removeNonShowButtons();
            this.widget.visible = false;
            this.changeButtonVisibility(true);
            if (this.nextButton != null && this.backButton != null) {
                this.backButton.setPosition(this.leftPos + 40, this.height / 2 - 4);
                this.nextButton.setPosition(this.leftPos + 190, this.height / 2 - 4);
                this.nextButton.setSize(16, 16);
                this.backButton.setSize(16, 16);
                this.homeButton.tex(HOME_BUTTON, HOME_BUTTON_HOVER);
                this.backButton.tex(BACK_ARROW, BACK_ARROW_HOVER);
                this.nextButton.tex(NEXT_ARROW, NEXT_ARROW_HOVER);
                this.homeButton.setSize(16, 16);
                this.homeButton.tex(HOME_BUTTON, HOME_BUTTON_HOVER);
                this.homeButton.setPosition(this.leftPos + 18, this.topPos + 22);
            }
        } else {
            this.removeAllButtons();
            this.widget.visible = true;
            this.changeButtonVisibility(false);
            if (this.nextButton != null && this.backButton != null) {
                this.backButton.setPosition(this.width / 2 - 19, this.height / 2 + 63);
                this.nextButton.setPosition(this.width / 2 + 11, this.height / 2 + 63);
                this.nextButton.setSize(10, 10);
                this.backButton.setSize(10, 10);
                this.backButton.tex(SMALL_BACK_ARROW, SMALL_BACK_ARROW);
                this.nextButton.tex(SMALL_NEXT_ARROW, SMALL_NEXT_ARROW);
                this.homeButton.tex(SMALL_HOME_BUTTON, SMALL_HOME_BUTTON);
                this.homeButton.setSize(10, 10);
                this.homeButton.setPosition(this.width / 2 - 4, this.height / 2 + 63);
            }
        }
    }

    protected void init() {
        this.homeButton = new TexturedButton(this.leftPos + 18, this.topPos + 22, 16, 16, button1 -> {
            if (Objects.equals(this.currentPage, "main")) {
                this.minecraft.setScreen((Screen)this.screen);
            } else {
                this.currentPage = "main";
                this.widget.visible = false;
            }
        }).tex(HOME_BUTTON, HOME_BUTTON_HOVER);
        this.addRenderableWidget((GuiEventListener)this.homeButton);
        AtomicInteger row = new AtomicInteger(0);
        AtomicInteger column = new AtomicInteger(0);
        this.entry.infos().forEach(infos -> {
            Object tabletButton = new TabletButton(this.leftPos + 68 + column.get() * 30, this.topPos + 60 + row.get() * 30, 20, 20, (Component)Component.translatable((String)infos.id()), button -> this.changeInfo((TabletEntry.Info)infos), (TabletEntry.Info)infos).tex(BUTTON_TEXTURE, BUTTON_HOVERED_TEXTURE);
            if (column.get() == 3) {
                column.set(0);
                row.getAndIncrement();
            } else {
                column.getAndIncrement();
            }
            this.PAGES_BUTTONS.add((TabletButton)((Object)((Object)tabletButton)));
            if (this.PAGES_BUTTONS.size() % 8 == 0) {
                column.set(0);
                row.set(0);
            }
            this.addButtonToList((TabletButton)((Object)((Object)tabletButton)));
            ((TabletButton)((Object)((Object)tabletButton))).visible = false;
            this.addRenderableWidget((GuiEventListener)tabletButton);
        });
        this.widget = new TabletEntryWidget(this.leftPos + 15, this.topPos + 40, 215, 100, (Component)Component.literal((String)""), null, this);
        this.widget.visible = false;
        this.addRenderableWidget((GuiEventListener)this.widget);
        if (this.ENTRY_BUTTONS.size() > 1) {
            this.backButton = new TexturedButton(this.leftPos + 40, this.height / 2 - 4, 16, 16, button1 -> this.changePage(false)).tex(BACK_ARROW, BACK_ARROW_HOVER);
            this.nextButton = new TexturedButton(this.leftPos + 190, this.height / 2 - 4, 16, 16, button1 -> this.changePage(true)).tex(NEXT_ARROW, NEXT_ARROW_HOVER);
            this.addRenderableWidget((GuiEventListener)this.backButton);
            this.addRenderableWidget((GuiEventListener)this.nextButton);
        }
        TabletMainScreen.BUTTONS.forEach(texButton -> {
            this.removeWidget((GuiEventListener)texButton);
            this.addRenderableWidget((GuiEventListener)texButton);
        });
    }

    public void changeButtonVisibility(boolean visible) {
        TabletMainScreen.BUTTONS.forEach(texButton -> {
            texButton.visible = visible;
        });
    }

    public void changeInfo(TabletEntry.Info info) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.entry.id(), (String)info.id());
        if (this.widget.setInfo(location)) {
            this.currentPage = location.toString();
        }
    }

    public void changePage(boolean next) {
        if (!Objects.equals(this.currentPage, "main")) {
            TabletEntry.Info info = this.getNextInfo(next);
            this.changeInfo(info);
            return;
        }
        this.currentEntryPage = next ? (this.currentEntryPage == this.ENTRY_BUTTONS.size() - 1 ? 0 : ++this.currentEntryPage) : (this.currentEntryPage == 0 ? this.ENTRY_BUTTONS.size() - 1 : --this.currentEntryPage);
        this.removeNonShowButtons();
        this.showEntryButton();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        TabletEntry.Info info;
        this.screen.resize(minecraft, width, height);
        this.leftPos = this.screen.getLeftPos();
        this.topPos = this.screen.getTopPos();
        super.resize(minecraft, width, height);
        String currentPage = this.currentPage;
        TabletEntryScreen newScreen = new TabletEntryScreen((Component)Component.translatable((String)this.entry.id()), this.screen, this.leftPos, this.topPos, this.entry);
        this.minecraft.setScreen((Screen)newScreen);
        if (!currentPage.equals("main") && (info = TabletMainScreen.INFOS.get(ResourceLocation.parse((String)currentPage))) != null) {
            newScreen.changeInfo(info);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Objects.equals(this.currentPage, "main")) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TabletMainScreen.MENU_BACKGROUND);
            guiGraphics.blit(TabletMainScreen.BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MENU_BACKGROUND_LIGHT);
            guiGraphics.blit(MENU_BACKGROUND_LIGHT, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (Objects.equals(this.currentPage, "main")) {
                this.screen.directEntry = null;
                this.minecraft.setScreen((Screen)this.screen);
            } else {
                this.currentPage = "main";
                this.widget.visible = false;
            }
            return true;
        }
        if (keyCode == 262) {
            this.changePage(true);
            return true;
        }
        if (keyCode == 263) {
            this.changePage(false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void showEntryButton() {
        this.ENTRY_BUTTONS.get(this.currentEntryPage).forEach(button -> {
            button.visible = true;
        });
    }

    public void removeNonShowButtons() {
        for (int i = 0; i < this.ENTRY_BUTTONS.size(); ++i) {
            if (i == this.currentEntryPage) continue;
            this.ENTRY_BUTTONS.get(i).forEach(button -> {
                button.visible = false;
            });
        }
    }

    public void removeAllButtons() {
        for (ArrayList<TabletButton> entryButton : this.ENTRY_BUTTONS) {
            entryButton.forEach(button -> {
                button.visible = false;
            });
        }
    }

    public void addButtonToList(TabletButton button) {
        if (this.ENTRY_BUTTONS.isEmpty()) {
            ArrayList<TabletButton> list = new ArrayList<TabletButton>();
            list.add(button);
            this.ENTRY_BUTTONS.add(list);
            return;
        }
        for (ArrayList<TabletButton> buttons : this.ENTRY_BUTTONS) {
            if (buttons.size() < 8) {
                buttons.add(button);
                break;
            }
            if (buttons.size() != 8 || this.ENTRY_BUTTONS.indexOf(buttons) + 1 < this.ENTRY_BUTTONS.size()) continue;
            ArrayList<TabletButton> list = new ArrayList<TabletButton>();
            list.add(button);
            this.ENTRY_BUTTONS.add(list);
            break;
        }
    }

    public TabletEntry.Info getNextInfo(boolean forward) {
        List<TabletEntry.Info> infos = this.entry.infos();
        int currentIndex = -1;
        for (int i = 0; i < infos.size(); ++i) {
            if (!infos.get(i).id().equals(this.getCurrentPage(this.currentPage))) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1) {
            if (!infos.isEmpty()) {
                return forward ? infos.getFirst() : infos.getLast();
            }
            return null;
        }
        int nextIndex = forward ? (currentIndex + 1) % infos.size() : (currentIndex - 1 + infos.size()) % infos.size();
        return infos.get(nextIndex);
    }

    public String getCurrentPage(String page) {
        return ResourceLocation.parse((String)page).getPath();
    }
}

