/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.tablet;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntryScreen;
import com.st0x0ef.stellaris.client.screens.tablet.TabletMainScreen;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TabletEntryWidget
extends AbstractScrollWidget {
    private static final ResourceLocation SCROLLER_SPRITE = Stellaris.id("icon/scroller");
    private final AtomicInteger finalHeight = new AtomicInteger(0);
    private TabletEntry.Info info;
    private int baseScreenWidth;
    private final TabletEntryScreen screen;
    private final ArrayList<ClickBox> clickBoxes = new ArrayList();

    public TabletEntryWidget(int x, int y, int width, int height, Component message, TabletEntry.Info info, TabletEntryScreen screen) {
        super(x, y, width, height, message);
        this.info = info;
        this.baseScreenWidth = screen.width;
        this.screen = screen;
    }

    protected int getInnerHeight() {
        return this.finalHeight.get() + this.finalHeight.get() / 2;
    }

    protected void renderBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    protected double scrollRate() {
        return 9.0;
    }

    protected void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.info == null) {
            return;
        }
        this.finalHeight.set(0);
        guiGraphics.drawCenteredString(this.getFont(), this.info.title(), this.baseScreenWidth / 2, this.getY() + this.finalHeight.get() + 20, Utils.getColorHexCode("white"));
        int descriptionHeight = this.renderDescriptionWithEveryWords(this.info.description(), this.getX() + 5, this.getY() + this.finalHeight.get() + 20 + 20, this.getWidth() - 20, guiGraphics);
        this.finalHeight.addAndGet(descriptionHeight);
        this.info.item().ifPresent(item -> {
            if (item.onlyIcon().isEmpty()) {
                ScreenHelper.renderItemWithCustomSize(guiGraphics, Minecraft.getInstance(), item.stack(), this.baseScreenWidth / 2 - (int)item.size() / 2, this.getY() + this.finalHeight.get() + 35 + 20, item.size());
                this.finalHeight.addAndGet(35 + (int)(item.size() / 4.0f));
            }
        });
        this.info.image().ifPresent(image -> {
            int height = this.getY() + 40 + this.finalHeight.get() + 20;
            guiGraphics.blit(image.location().withSuffix(".png"), this.baseScreenWidth / 2 - image.width() / 2, height, 0.0f, 0.0f, image.width(), image.height(), image.width(), image.height());
            this.finalHeight.addAndGet(image.height() + 40);
        });
        this.info.entity().ifPresent(entity -> {
            int height = this.getY() + 40 + this.finalHeight.get() + entity.scale();
            Entity entity1 = ScreenHelper.createEntity((Level)Minecraft.getInstance().level, entity.entity());
            ScreenHelper.renderEntityInInventory(guiGraphics, (float)this.baseScreenWidth / 2.0f, height + 45, entity.scale(), new Vector3f(), new Quaternionf(-1.0f, 0.0f, 0.0f, 0.0f), null, entity1);
            this.finalHeight.addAndGet(80);
        });
    }

    public void resize(TabletEntryScreen screen) {
        this.baseScreenWidth = screen.width;
        this.setInfo(ResourceLocation.parse((String)screen.currentPage));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void renderScrollBar(GuiGraphics guiGraphics) {
        int i = this.getScrollBarHeight();
        int j = this.getX() + this.width;
        int k = Math.max(this.getY(), (int)this.scrollAmount() * (this.height - i) / this.getMaxScrollAmount() + this.getY());
        RenderSystem.enableBlend();
        guiGraphics.blitSprite(SCROLLER_SPRITE, j, k, 8, i);
        RenderSystem.disableBlend();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (ClickBox clickBox : this.clickBoxes) {
            if (!clickBox.isHovered((int)mouseX, (int)mouseY, (int)this.scrollAmount())) continue;
            clickBox.changePage(this.screen);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void addClickBox(double x, double y, double width, double height, String brutText) {
        Pattern pattern = Pattern.compile("\\[ref=.*?\\]");
        Matcher matcher = pattern.matcher(brutText);
        while (matcher.find()) {
            String ref = matcher.group().replace("[ref=", "").replace("]", "");
            ClickBox clickBox = new ClickBox((int)x, (int)y, (int)width, (int)height, ref);
            if (this.clickBoxes.contains(clickBox)) continue;
            this.clickBoxes.add(clickBox);
        }
    }

    public String removeRef(String text) {
        String regex = "\\[ref=.*?\\]";
        return text.replaceAll(regex, "");
    }

    public int renderDescriptionWithEveryWords(String description, int x, int y, int maxWidth, GuiGraphics guiGraphics) {
        List<ArrayList<String>> lines = this.createLines(description, maxWidth);
        for (int i = 0; i < lines.size(); ++i) {
            ArrayList<String> words = lines.get(i);
            AtomicInteger width = new AtomicInteger(0);
            for (String word : words) {
                String color = "white";
                if (word.contains("[color=")) {
                    color = word.substring(7, word.indexOf("]"));
                    word = word.replace("[color=" + color + "]", "");
                } else if (word.contains("[ref=")) {
                    double d = x + width.get();
                    Objects.requireNonNull(this.getFont());
                    double d2 = y + i * 9;
                    double d3 = this.getFont().width(this.removeRef(word));
                    Objects.requireNonNull(this.getFont());
                    this.addClickBox(d, d2, d3, 9.0, word);
                    word = this.removeRef(word);
                    color = "blue";
                }
                Font font = this.getFont();
                int n = x + width.get();
                Objects.requireNonNull(this.getFont());
                guiGraphics.drawString(font, word, n, y + i * 9, Utils.getColorHexCode(color));
                width.addAndGet(Minecraft.getInstance().font.width(word + " "));
            }
            width.set(0);
        }
        int n = lines.size();
        Objects.requireNonNull(this.getFont());
        return n * 9;
    }

    public List<ArrayList<String>> createLines(String message, int maxWidth) {
        String[] words = message.split("\\s+");
        ArrayList<ArrayList<String>> lines = new ArrayList<ArrayList<String>>();
        ArrayList<String> wordsInLine = new ArrayList<String>();
        AtomicInteger remainingWords = new AtomicInteger(words.length);
        AtomicInteger width = new AtomicInteger(words.length);
        for (String word : words) {
            remainingWords.getAndDecrement();
            int wordWidth = Minecraft.getInstance().font.width(word + " ");
            if (word.contains("[br]")) {
                lines.add(wordsInLine);
                wordsInLine = new ArrayList();
                width.set(0);
                continue;
            }
            if (word.contains("[color=")) {
                String wordWithoutColor = word.replace("[color=" + word.substring(7, word.indexOf("]")) + "]", "");
                wordWidth = Minecraft.getInstance().font.width(wordWithoutColor + " ");
            } else if (word.contains("[ref=")) {
                wordWidth = Minecraft.getInstance().font.width(this.removeRef(word) + " ");
            }
            if (wordWidth + width.get() < maxWidth) {
                if (remainingWords.get() == 0) {
                    wordsInLine.add(word);
                    lines.add(wordsInLine);
                    break;
                }
                wordsInLine.add(word);
                width.addAndGet(wordWidth);
                continue;
            }
            width.set(0);
            lines.add(wordsInLine);
            wordsInLine = new ArrayList();
            wordsInLine.add(word);
        }
        return lines;
    }

    public Font getFont() {
        return Minecraft.getInstance().font;
    }

    public boolean setInfo(ResourceLocation location) {
        try {
            this.info = TabletMainScreen.INFOS.get(location);
            this.setScrollAmount(0.0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private record ClickBox(int x, int y, int width, int height, String action) {
        public boolean isHovered(int mouseX, int mouseY, int finalHeight) {
            return mouseX >= this.x && mouseX <= this.x + this.width && (mouseY += finalHeight) >= this.y && mouseY <= this.y + this.height;
        }

        public void changePage(TabletEntryScreen entryScreen) {
            ResourceLocation location = ResourceLocation.parse((String)this.action);
            entryScreen.widget.setInfo(location);
        }
    }
}

