/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.energy.BaseEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import com.st0x0ef.stellaris.common.blocks.entities.ImplementedInventory;
import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.network.packets.SyncEnergyPacketWithoutDirection;
import com.st0x0ef.stellaris.common.utils.capabilities.energy.EnergyStorage;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEnergyContainerBlockEntity
extends BaseContainerBlockEntity
implements EnergyProvider.BLOCK,
ImplementedInventory,
TickingBlockEntity {
    public static final String ENERGY_TAG = "stellaris.energyContainer";
    protected EnergyStorage energyContainer;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);

    public BaseEnergyContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int initialMaxCapacity, int initialMaxInsert, int initialMaxExtract) {
        super(type, pos, state);
        this.energyContainer = new EnergyStorage(initialMaxCapacity, initialMaxInsert, initialMaxExtract){

            @Override
            protected void onChange() {
                BaseEnergyContainerBlockEntity.this.setChanged();
                if (BaseEnergyContainerBlockEntity.this.level != null && BaseEnergyContainerBlockEntity.this.level.getServer() != null && !BaseEnergyContainerBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)BaseEnergyContainerBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncEnergyPacketWithoutDirection(BaseEnergyContainerBlockEntity.this.energyContainer.getEnergy(), BaseEnergyContainerBlockEntity.this.getBlockPos()));
                }
            }
        };
    }

    public BaseEnergyContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int initialMaxCapacity) {
        this(type, pos, state, initialMaxCapacity, initialMaxCapacity, initialMaxCapacity);
    }

    public BaseEnergyContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 15000);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    @Override
    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.getEnergy(null).setEnergyStored(tag.getInt(ENERGY_TAG));
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt(ENERGY_TAG, this.getEnergy(null).getEnergy());
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    @NotNull
    public BaseEnergyStorage getEnergy(@Nullable Direction direction) {
        return this.energyContainer;
    }
}

