/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.WaterSeparatorBlock;
import com.st0x0ef.stellaris.common.data.recipes.WaterSeparatorRecipe;
import com.st0x0ef.stellaris.common.data.recipes.input.FluidInput;
import com.st0x0ef.stellaris.common.menus.WaterSeparatorMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacket;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidStorage;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterSeparatorBlockEntity
extends BaseEnergyContainerBlockEntity
implements FluidProvider.BLOCK {
    public static final int HYDROGEN_TANK = 0;
    public static final int OXYGEN_TANK = 1;
    public final SingleFluidStorage ingredientTank = new SingleFluidStorage(3000L, 3000L, 0L){

        @Override
        protected void onChange() {
            WaterSeparatorBlockEntity.this.setChanged();
            if (WaterSeparatorBlockEntity.this.level != null && WaterSeparatorBlockEntity.this.level.getServer() != null && !WaterSeparatorBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                NetworkManager.sendToPlayers((Iterable)WaterSeparatorBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, WaterSeparatorBlockEntity.this.getBlockPos(), Direction.UP));
            }
        }

        @Override
        public boolean isFluidValid(int tank, FluidStack stack) {
            return stack.getFluid() == Fluids.WATER;
        }
    };
    public final FluidStorage resultTanks = new FluidStorage(2, 6000L, 0L, 1000L){

        @Override
        protected void onChange(int tank) {
            WaterSeparatorBlockEntity.this.setChanged();
            if (WaterSeparatorBlockEntity.this.level != null && WaterSeparatorBlockEntity.this.level.getServer() != null && !WaterSeparatorBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                NetworkManager.sendToPlayers((Iterable)WaterSeparatorBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(tank).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank(tank)))), tank, WaterSeparatorBlockEntity.this.getBlockPos(), ((Direction)WaterSeparatorBlockEntity.this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getClockWise()));
            }
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            if (tank == 0) {
                return stack.getFluid() == FluidRegistry.HYDROGEN_STILL.get();
            }
            if (tank == 1) {
                return stack.getFluid() == FluidRegistry.OXYGEN_STILL.get();
            }
            return false;
        }
    };
    private final RecipeManager.CachedCheck<FluidInput, WaterSeparatorRecipe> cachedCheck = RecipeManager.createCheck((RecipeType)((RecipeType)RecipesRegistry.WATER_SEPERATOR_TYPE.get()));

    public WaterSeparatorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.WATER_SEPARATOR_ENTITY.get(), pos, state);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.water_separator");
    }

    @Override
    public int getContainerSize() {
        return 4;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new WaterSeparatorMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public void tick() {
        FluidUtil.moveFluidToItem(1, (UniversalFluidStorage)this.resultTanks, 3, (NonNullList<ItemStack>)this.items, 1000L);
        FluidUtil.moveFluidToItem(0, (UniversalFluidStorage)this.resultTanks, 2, (NonNullList<ItemStack>)this.items, 1000L);
        FluidUtil.moveFluidFromItem(0, 1, (NonNullList<ItemStack>)this.items, this.ingredientTank, 1000L);
        Direction facing = (Direction)this.getBlockState().getValue((Property)WaterSeparatorBlock.FACING);
        FluidUtil.distributeFluidNearby(this.level, this.worldPosition, this.resultTanks.getFluidInTank(0), List.of(facing.getClockWise()));
        FluidUtil.distributeFluidNearby(this.level, this.worldPosition, this.resultTanks.getFluidInTank(1), List.of(facing.getCounterClockWise()));
        FluidUtil.distributeFluidNearby(this.level, this.worldPosition, this.ingredientTank.getFluidInTank(0), List.of(Direction.UP, Direction.DOWN, facing, facing.getOpposite()));
        if (this.level == null) {
            return;
        }
        Optional recipeHolder = this.cachedCheck.getRecipeFor((RecipeInput)new FluidInput((BlockEntity)this), this.level);
        if (recipeHolder.isPresent()) {
            WaterSeparatorRecipe recipe = (WaterSeparatorRecipe)((RecipeHolder)recipeHolder.get()).value();
            if (this.energyContainer.getEnergy() >= recipe.energy()) {
                boolean shouldDrainWaterAndEnergy = false;
                if (this.resultTanks.getFluidValueInTank(0) < this.resultTanks.getTankCapacity(0)) {
                    this.resultTanks.fillWithoutLimits(recipe.resultStacks().getFirst(), false);
                    shouldDrainWaterAndEnergy = true;
                }
                if (this.resultTanks.getFluidValueInTank(1) < this.resultTanks.getTankCapacity(1)) {
                    this.resultTanks.fillWithoutLimits(recipe.resultStacks().get(1), false);
                    shouldDrainWaterAndEnergy = true;
                }
                if (shouldDrainWaterAndEnergy) {
                    this.ingredientTank.drainWithoutLimits(recipe.ingredientStack(), false);
                    this.energyContainer.extract(recipe.energy(), false);
                }
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.ingredientTank.save(tag, provider, "ingredient");
        this.resultTanks.save(tag, provider, "result");
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.ingredientTank.load(tag, provider, "ingredient");
        this.resultTanks.load(tag, provider, "result");
    }

    @Nullable
    public UniversalFluidStorage getFluidTank(@Nullable Direction direction) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        if (facing.getCounterClockWise() == direction || facing.getClockWise() == direction) {
            return this.resultTanks;
        }
        return this.ingredientTank;
    }

    public SingleFluidStorage getIngredientTank() {
        return this.ingredientTank;
    }

    public FluidStorage getResultTanks() {
        return this.resultTanks;
    }
}

