/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.planets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.data.planets.PlanetTextures;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public record Planet(String system, String translatable, String name, ResourceLocation dimension, boolean oxygen, float temperature, int distanceFromEarth, float gravity, Optional<StormParameters> stormParameters, PlanetTextures textures) {
    public static final Codec<Planet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("system").forGetter(Planet::system), (App)Codec.STRING.fieldOf("translatable").forGetter(Planet::translatable), (App)Codec.STRING.fieldOf("name").forGetter(Planet::name), (App)ResourceLocation.CODEC.fieldOf("level").forGetter(Planet::dimension), (App)Codec.BOOL.fieldOf("oxygen").forGetter(Planet::oxygen), (App)Codec.FLOAT.fieldOf("temperature").forGetter(Planet::temperature), (App)Codec.INT.fieldOf("distanceFromEarth").forGetter(Planet::distanceFromEarth), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Planet::gravity), (App)StormParameters.CODEC.optionalFieldOf("stormParameters").forGetter(Planet::stormParameters), (App)PlanetTextures.CODEC.fieldOf("textures").forGetter(Planet::textures)).apply((Applicative)instance, Planet::new));

    public static RegistryFriendlyByteBuf toBuffer(List<Planet> planets, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(planets.size());
        planets.forEach(planet -> {
            buffer.writeUtf(planet.system);
            buffer.writeUtf(planet.translatable);
            buffer.writeUtf(planet.name);
            buffer.writeResourceLocation(planet.dimension);
            buffer.writeBoolean(planet.oxygen);
            buffer.writeFloat(planet.temperature);
            buffer.writeInt(planet.distanceFromEarth);
            buffer.writeFloat(planet.gravity);
            buffer.writeOptional(planet.stormParameters, (buf, parameters) -> parameters.toNetwork(buffer));
            planet.textures.toNetwork(buffer);
        });
        return buffer;
    }

    public static List<Planet> readFromBuffer(RegistryFriendlyByteBuf buffer) {
        ArrayList<Planet> planets = new ArrayList<Planet>();
        int k = buffer.readInt();
        for (int i = 0; i < k; ++i) {
            planets.add(new Planet(buffer.readUtf(), buffer.readUtf(), buffer.readUtf(), buffer.readResourceLocation(), buffer.readBoolean(), buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.readOptional(StormParameters::readBuffer), PlanetTextures.fromNetwork(buffer)));
        }
        return planets;
    }

    public Component getTranslation() {
        return Component.translatable((String)this.translatable);
    }

    public record StormParameters(int lightningFrequency, Vec3 lightningColor) {
        public static final Codec<StormParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("lightningFrequency").forGetter(StormParameters::lightningFrequency), (App)Vec3.CODEC.fieldOf("color").forGetter(StormParameters::lightningColor)).apply((Applicative)instance, StormParameters::new));

        public RegistryFriendlyByteBuf toNetwork(RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(this.lightningFrequency());
            buffer.writeVec3(this.lightningColor());
            return buffer;
        }

        @Override
        public String toString() {
            return "StormParameters{, lightningFrequency=" + this.lightningFrequency + ", lightningColor=" + String.valueOf(this.lightningColor) + "}";
        }

        public static StormParameters readBuffer(FriendlyByteBuf buffer) {
            return new StormParameters(buffer.readInt(), buffer.readVec3());
        }
    }
}

