/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.events.custom.PlanetSelectionClientEvents;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.record.StarRecord;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarPack
extends SimpleJsonResourceReloadListener {
    public static final Map<String, StarRecord> STAR = new HashMap<String, StarRecord>();
    public static int count = 0;

    public StarPack() {
        super(Stellaris.GSON, "renderer/planet_screen/star");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (count > 0) {
            return;
        }
        STAR.clear();
        object.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"stars");
            StarRecord star = (StarRecord)StarRecord.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            STAR.put(star.name(), star);
            int orbitColor = Utils.getColorHexCode(star.orbitColor());
            CelestialBody screenStar = new CelestialBody(star.texture(), star.name(), star.x(), star.y(), star.width(), star.height(), orbitColor, null, star.translatable(), star.id());
            for (int i = 0; i < PlanetSelectionScreen.STARS.size(); ++i) {
                if (!PlanetSelectionScreen.STARS.get(i).getId().equals(star.id())) continue;
                PlanetSelectionScreen.STARS.set(i, screenStar);
                Stellaris.LOG.info("Replaced existing star in PlanetSelectionScreen : {}", (Object)star.id());
                return;
            }
            PlanetSelectionScreen.STARS.add(screenStar);
            Stellaris.LOG.info("Added a new star to PlanetSelectionScreen : {}", (Object)star.id());
        });
        ++count;
        ((PlanetSelectionClientEvents.PostStarPackRegistryEvent)PlanetSelectionClientEvents.POST_STAR_PACK_REGISTRY.invoker()).starsRegistered(PlanetSelectionScreen.STARS);
    }
}

