/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.effects;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FoggingScreenEffect
extends MobEffect {
    public static ResourceLocation FOGGING_OVERLAY = Stellaris.texture("overlay/fogging_overlay");

    public FoggingScreenEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public int getBlendDurationTicks() {
        return 50;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FoggingScreenFogFunction
    implements FogRenderer.MobEffectFogFunction {
        public Holder<MobEffect> getMobEffect() {
            return EffectsRegistry.getHolder(EffectsRegistry.FOGGING_OVERLAY);
        }

        public float getModifiedVoidDarkness(LivingEntity entity, MobEffectInstance effectInstance, float tick, float partialTick) {
            return tick;
        }

        public void setupFog(FogRenderer.FogData fogData, LivingEntity entity, MobEffectInstance effectInstance, float farPlaneDistance, float f) {
            float partness;
            float f2 = partness = effectInstance.isInfiniteDuration() ? 20.0f : Mth.lerp((float)Math.min(1.0f, (float)effectInstance.getDuration() / 40.0f), (float)farPlaneDistance, (float)20.0f);
            if (fogData.mode == FogRenderer.FogMode.FOG_SKY) {
                fogData.start = 4.0f;
                fogData.end = partness * 0.8f;
            } else {
                fogData.start = partness * 0.25f;
                fogData.end = partness;
            }
        }
    }
}

