/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles.base;

import com.st0x0ef.stellaris.common.entities.vehicles.IVehicleEntity;
import com.st0x0ef.stellaris.common.network.packets.SyncRoverPacket;
import com.st0x0ef.stellaris.common.utils.MathUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public abstract class AbstractRoverBase
extends IVehicleEntity {
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;
    private float wheelRotation;
    private boolean collidedLastTick;
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(AbstractRoverBase.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> FORWARD = SynchedEntityData.defineId(AbstractRoverBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BACKWARD = SynchedEntityData.defineId(AbstractRoverBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.defineId(AbstractRoverBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.defineId(AbstractRoverBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();

    public AbstractRoverBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.blocksBuilding = true;
        this.recalculateBoundingBox();
    }

    public abstract float getMaxSpeed();

    public abstract float getMaxReverseSpeed();

    public abstract float getAcceleration();

    public abstract float getMaxRotationSpeed();

    public abstract float getMinRotationSpeed();

    public abstract float getRollResistance();

    public abstract float getRotationModifier();

    public abstract float getPitch();

    @Override
    public void tick() {
        Runnable task;
        super.tick();
        while ((task = (Runnable)this.tasks.poll()) != null) {
            task.run();
        }
        this.updateGravity();
        this.controlRover();
        this.checkPush();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
        }
        this.updateWheelRotation();
        this.tickLerp();
    }

    public void centerCar() {
        Direction facing = this.getDirection();
        switch (facing) {
            case SOUTH: {
                this.setYRot(0.0f);
                break;
            }
            case NORTH: {
                this.setYRot(180.0f);
                break;
            }
            case EAST: {
                this.setYRot(-90.0f);
                break;
            }
            case WEST: {
                this.setYRot(90.0f);
            }
        }
    }

    public boolean canCollideWith(Entity entityIn) {
        float speed;
        if (!this.level().isClientSide && entityIn instanceof LivingEntity && !this.getPassengers().contains(entityIn) && entityIn.getBoundingBox().intersects(this.getBoundingBox()) && (speed = this.getSpeed()) > 0.35f) {
            float damage = speed * 10.0f;
            this.tasks.add(() -> {
                ServerLevel serverLevel = (ServerLevel)this.level();
                Optional holder = serverLevel.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DamageTypes.DROWN);
                holder.ifPresent(damageTypeReference -> entityIn.hurt(new DamageSource((Holder)damageTypeReference, (Entity)this), damage));
            });
        }
        return (entityIn.canBeCollidedWith() || entityIn.isPushable()) && !this.isPassengerOfSameVehicle(entityIn);
    }

    public void checkPush() {
        List list = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(0.2, 0.0, 0.2).expandTowards(-0.2, 0.0, -0.2));
        for (Player player : list) {
            if (player.hasPassenger((Entity)this) || !player.isShiftKeyDown()) continue;
            double motX = AbstractRoverBase.calculateMotionX(0.05f, player.getYRot());
            double motZ = AbstractRoverBase.calculateMotionZ(0.05f, player.getYRot());
            this.move(MoverType.PLAYER, new Vec3(motX, 0.0, motZ));
            return;
        }
    }

    public void controlRover() {
        if (!this.isVehicle() && this.isEnoughFuel()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        float modifier = 0.5f;
        float maxSp = this.getMaxSpeed() * modifier;
        float maxBackSp = this.getMaxReverseSpeed() * modifier;
        float speed = MathUtils.subtractToZero(this.getSpeed(), this.getRollResistance());
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.getAcceleration(), maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.getAcceleration(), -maxBackSp);
        }
        this.setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = Mth.abs((float)(this.getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = Mth.clamp((float)rotationSpeed, (float)this.getMinRotationSpeed(), (float)this.getMaxRotationSpeed());
        }
        this.deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.deltaRotation = Mth.clamp((float)this.deltaRotation, (float)-45.0f, (float)45.0f);
        this.setYRot(this.getYRot() + this.deltaRotation);
        float delta = Math.abs(this.getYRot() - this.yRotO);
        while (this.getYRot() > 180.0f) {
            this.setYRot(this.getYRot() - 360.0f);
            this.yRotO = this.getYRot() - delta;
        }
        while (this.getYRot() <= -180.0f) {
            this.setYRot(this.getYRot() + 360.0f);
            this.yRotO = delta + this.getYRot();
        }
        if (this.horizontalCollision) {
            if (this.level().isClientSide && !this.collidedLastTick) {
                this.onCollision(speed);
                this.collidedLastTick = true;
            }
        } else {
            this.setDeltaMovement(AbstractRoverBase.calculateMotionX(this.getSpeed(), this.getYRot()), this.getDeltaMovement().y, AbstractRoverBase.calculateMotionZ(this.getSpeed(), this.getYRot()));
            if (this.level().isClientSide) {
                this.collidedLastTick = false;
            }
        }
    }

    protected abstract boolean isEnoughFuel();

    private float getaFloat() {
        float modifier = 1.0f;
        float maxSp = this.getMaxSpeed() * modifier;
        float maxBackSp = this.getMaxReverseSpeed() * modifier;
        float speed = MathUtils.subtractToZero(this.getSpeed(), this.getRollResistance());
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.getAcceleration(), maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.getAcceleration(), -maxBackSp);
        }
        return speed;
    }

    public void onCollision(float speed) {
        this.setSpeed(0.01f);
        this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
    }

    public boolean canPlayerDriveCar(Player player) {
        if (player.equals((Object)this.getDriver())) {
            return true;
        }
        if (this.isInWater() || this.isInLava()) {
            return false;
        }
        return false;
    }

    private void updateGravity() {
        if (this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
            return;
        }
        this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y - 0.2, this.getDeltaMovement().z);
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.level().isClientSide && needsUpdate) {
            NetworkManager.sendToServer((CustomPacketPayload)new SyncRoverPacket(forward, backward, left, right, player));
        }
    }

    public abstract double getPlayerYOffset();

    public boolean canPlayerEnterCar(Player player) {
        return true;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            if (player.getVehicle() != this && !this.level().isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.canPlayerEnterCar(player)) {
            return InteractionResult.FAIL;
        }
        return super.interact(player, hand);
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float getWheelRotationAmount() {
        return 120.0f * this.getSpeed();
    }

    public void updateWheelRotation() {
        this.wheelRotation += this.getWheelRotationAmount();
    }

    public float getWheelRotation(float partialTicks) {
        return this.wheelRotation + this.getWheelRotationAmount() * partialTicks;
    }

    public boolean isAccelerating() {
        return (this.isForward() || this.isBackward()) && !this.horizontalCollision;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPEED, (Object)Float.valueOf(0.0f));
        builder.define(FORWARD, (Object)false);
        builder.define(BACKWARD, (Object)false);
        builder.define(LEFT, (Object)false);
        builder.define(RIGHT, (Object)false);
    }

    @Override
    public void setSpeed(float speed) {
        this.entityData.set(SPEED, (Object)Float.valueOf(speed));
    }

    @Override
    public float getSpeed() {
        return ((Float)this.entityData.get(SPEED)).floatValue();
    }

    public void setForward(boolean forward) {
        this.entityData.set(FORWARD, (Object)forward);
    }

    public boolean isForward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.entityData.get(FORWARD);
    }

    public void setBackward(boolean backward) {
        this.entityData.set(BACKWARD, (Object)backward);
    }

    public boolean isBackward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.entityData.get(BACKWARD);
    }

    public void setLeft(boolean left) {
        this.entityData.set(LEFT, (Object)left);
    }

    public boolean isLeft() {
        return (Boolean)this.entityData.get(LEFT);
    }

    public void setRight(boolean right) {
        this.entityData.set(RIGHT, (Object)right);
    }

    public boolean isRight() {
        return (Boolean)this.entityData.get(RIGHT);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public float maxUpStep() {
        return 1.0f;
    }

    public void recalculateBoundingBox() {
        double width = this.getCarWidth();
        double height = this.getCarHeight();
        this.setBoundingBox(new AABB(this.getX() - width / 2.0, this.getY(), this.getZ() - width / 2.0, this.getX() + width / 2.0, this.getY() + height, this.getZ() + width / 2.0));
    }

    public double getCarWidth() {
        return 1.3;
    }

    public double getCarHeight() {
        return 1.6;
    }

    public Player getDriver() {
        List passengers = this.getPassengers();
        if (passengers.isEmpty()) {
            return null;
        }
        if (passengers.getFirst() instanceof Player) {
            return (Player)passengers.getFirst();
        }
        return null;
    }

    public abstract int getPassengerSize();

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < this.getPassengerSize();
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.yRotO += f1 - f;
        entityToUpdate.setYRot(entityToUpdate.getYRot() + f1 - f);
        entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
    }

    public void onPassengerTurned(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public abstract Vector3d[] getPlayerOffsets();

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        double front = 0.0;
        double side = 0.0;
        double height = 0.0;
        List passengers = this.getPassengers();
        if (!passengers.isEmpty()) {
            int i = passengers.indexOf(passenger);
            Vector3d offset = this.getPlayerOffsets()[i];
            front = offset.x;
            side = offset.z;
            height = offset.y;
        }
        Vec3 vec3d = new Vec3(front, height, side).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        passenger.setPos(this.getX() + vec3d.x, this.getY() + vec3d.y, this.getZ() + vec3d.z);
        passenger.setYRot(passenger.getYRot() + this.deltaRotation);
        passenger.setYHeadRot(passenger.getYHeadRot() + this.deltaRotation);
        this.applyYawToEntity(passenger);
    }

    public LivingEntity getControllingPassenger() {
        return this.getDriver();
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isPushable() {
        return true;
    }

    @Override
    public boolean isPickable() {
        return this.isAlive();
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.steps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.steps > 0) {
            double d0 = this.getX() + (this.clientX - this.getX()) / (double)this.steps;
            double d1 = this.getY() + (this.clientY - this.getY()) / (double)this.steps;
            double d2 = this.getZ() + (this.clientZ - this.getZ()) / (double)this.steps;
            double d3 = Mth.wrapDegrees((double)(this.clientYaw - (double)this.getYRot()));
            this.setYRot((float)((double)this.getYRot() + d3 / (double)this.steps));
            this.setXRot((float)((double)this.getXRot() + (this.clientPitch - (double)this.getXRot()) / (double)this.steps));
            --this.steps;
            this.setPos(d0, d1, d2);
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static double calculateMotionX(float speed, float rotationYaw) {
        return Mth.sin((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static double calculateMotionZ(float speed, float rotationYaw) {
        return Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public abstract boolean doesEnterThirdPerson();

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(entity);
        }
        int[][] offsets = DismountHelper.offsetsForDirection((Direction)direction);
        AABB bb = entity.getLocalBoundsForPose(Pose.STANDING);
        AABB carBB = this.getBoundingBox();
        for (int[] offset : offsets) {
            Vec3 dismountPos = new Vec3(this.getX() + (double)offset[0] * (carBB.getXsize() / 2.0 + bb.getXsize() / 2.0 + 0.0625), this.getY(), this.getZ() + (double)offset[1] * (carBB.getXsize() / 2.0 + bb.getXsize() / 2.0 + 0.0625));
            double y = this.level().getBlockFloorHeight(new BlockPos((int)dismountPos.x, (int)dismountPos.y, (int)dismountPos.z));
            if (!DismountHelper.isBlockFloorValid((double)y) || !DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)entity, (AABB)bb.move(dismountPos))) continue;
            return dismountPos;
        }
        return super.getDismountLocationForPassenger(entity);
    }
}

