/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.events;

import com.st0x0ef.stellaris.common.blocks.CoalLanternBlock;
import com.st0x0ef.stellaris.common.blocks.WallCoalTorchBlock;
import com.st0x0ef.stellaris.common.data_components.RadioactiveComponent;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class Events {
    private static final int RADIATION_CHECK_INTERVAL = 100;
    private static int tickBeforeNextRadioactiveCheck = 100;

    public static void registerEvents() {
        TickEvent.PLAYER_POST.register(player -> {
            if (!player.level().isClientSide()) {
                if (tickBeforeNextRadioactiveCheck <= 0 && !Utils.isLivingInJetSuit((LivingEntity)player)) {
                    int level = player.getInventory().items.stream().filter(stack -> stack.has((DataComponentType)DataComponentsRegistry.RADIOACTIVE.get())).mapToInt(stack -> ((RadioactiveComponent)stack.get((DataComponentType)DataComponentsRegistry.RADIOACTIVE.get())).level()).max().orElse(-1);
                    if (level >= 0) {
                        player.addEffect(new MobEffectInstance(EffectsRegistry.getHolder(EffectsRegistry.RADIOACTIVE), 100, level));
                    }
                    tickBeforeNextRadioactiveCheck = 100;
                }
                --tickBeforeNextRadioactiveCheck;
            }
        });
        BlockEvent.BREAK.register((level, pos, state, player, value) -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (state.is(BlocksRegistry.OXYGEN_DISTRIBUTOR) && state.is(BlocksRegistry.OXYGEN_DISTRIBUTOR)) {
                    GlobalOxygenManager.getInstance().getOrCreateDimensionManager(serverLevel).removeOxygenRoom(pos);
                }
            }
            return EventResult.pass();
        });
        BlockEvent.PLACE.register((level, pos, state, player) -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!PlanetUtil.hasOxygen(level)) {
                    if (state.is(Blocks.TORCH)) {
                        serverLevel.setBlockAndUpdate(pos, ((Block)BlocksRegistry.COAL_TORCH_BLOCK.get()).defaultBlockState());
                        return EventResult.interruptFalse();
                    }
                    if (state.is(Blocks.WALL_TORCH)) {
                        serverLevel.setBlockAndUpdate(pos, (BlockState)((Block)BlocksRegistry.WALL_COAL_TORCH_BLOCK.get()).defaultBlockState().setValue((Property)WallCoalTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))));
                        return EventResult.interruptFalse();
                    }
                    if (state.is(Blocks.LANTERN)) {
                        serverLevel.setBlockAndUpdate(pos, (BlockState)((Block)BlocksRegistry.COAL_LANTERN_BLOCK.get()).defaultBlockState().setValue((Property)CoalLanternBlock.HANGING, (Comparable)((Boolean)state.getValue((Property)LanternBlock.HANGING))));
                        return EventResult.interruptFalse();
                    }
                    if (state.is(BlocksRegistry.OXYGEN_DISTRIBUTOR)) {
                        GlobalOxygenManager.getInstance().getOrCreateDimensionManager(serverLevel).addOxygenRoom(pos);
                    }
                }
            }
            return EventResult.pass();
        });
        TickEvent.SERVER_LEVEL_POST.register(level -> GlobalOxygenManager.getInstance().getOrCreateDimensionManager((ServerLevel)level).updateOxygenTick());
    }

    private static void removeOxygenRoom(ServerLevel level, BlockPos pos) {
        GlobalOxygenManager.getInstance().getOrCreateDimensionManager(level).removeOxygenRoom(pos);
    }
}

