/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.fej1fun.potentials.energy.ItemEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import com.st0x0ef.stellaris.common.oil.OilUtils;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class OilFinderItem
extends Item
implements EnergyProvider.ITEM {
    public OilFinderItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide()) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
        }
        int oilLevel = level.getChunk(player.getOnPos()).stellaris$getChunkOilLevel();
        MutableComponent component = Component.literal((String)("Found Oil " + level.getChunk(player.getOnPos()).stellaris$getChunkOilLevel() + "mb"));
        if (oilLevel == 0) {
            component = Component.literal((String)"No oil found");
        }
        component.withColor(OilUtils.getOilLevelColor(oilLevel));
        player.getItemInHand(usedHand).hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
        player.displayClientMessage((Component)component, true);
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
    }

    @NotNull
    public ItemEnergyStorage getEnergy(@NotNull ItemStack stack) {
        return new ItemEnergyStorage(stack, (DataComponentType)DataComponentsRegistry.ENERGY.get(), 1000, 20, 1);
    }
}

