/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.common.blocks.RocketLaunchPad;
import com.st0x0ef.stellaris.common.data_components.RocketComponent;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class RocketItem
extends Item {
    public RocketItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level;
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        InteractionHand hand = context.getHand();
        ItemStack itemStack = context.getItemInHand();
        if (state.getBlock() instanceof RocketLaunchPad && ((Boolean)state.getValue((Property)RocketLaunchPad.STAGE)).booleanValue() && (level = context.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPlaceContext blockplacecontext = new BlockPlaceContext(context);
            BlockPos blockpos = blockplacecontext.getClickedPos();
            Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)blockpos, (double)this.getRocketPlaceHigh());
            AABB aabb = ((EntityType)EntityRegistry.BIG_ROCKET.get()).getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
            if (level2.noCollision(aabb)) {
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                AABB scanAbove = new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                List entities = player.getCommandSenderWorld().getEntitiesOfClass(Entity.class, scanAbove);
                if (entities.isEmpty()) {
                    RocketEntity rocket = this.getRocket(context.getLevel(), itemStack);
                    rocket.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                    double d0 = RocketItem.getYOffset((LevelReader)level2, pos, true, rocket.getBoundingBox());
                    float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 45.0f) / 90.0f)) * 90.0f;
                    rocket.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + d0, (double)pos.getZ() + 0.5, f, 0.0f);
                    rocket.yRotO = rocket.getYRot();
                    if (level2.addFreshEntity((Entity)rocket)) {
                        if (!player.getAbilities().instabuild) {
                            player.setItemInHand(hand, ItemStack.EMPTY);
                        }
                        this.rocketPlaceSound(pos, (Level)level2);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.useOn(context);
    }

    public EntityType<? extends RocketEntity> getEntityType(ItemStack stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        return switch (rocketComponent.getModel().toString()) {
            case "small" -> (EntityType)EntityRegistry.SMALL_ROCKET.get();
            case "normal" -> (EntityType)EntityRegistry.NORMAL_ROCKET.get();
            case "big" -> (EntityType)EntityRegistry.BIG_ROCKET.get();
            default -> (EntityType)EntityRegistry.TINY_ROCKET.get();
        };
    }

    public RocketEntity getRocket(Level level, ItemStack stack) {
        RocketEntity rocket = new RocketEntity(this.getEntityType(stack), level);
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        if (rocketComponent != null) {
            rocket.setRocketComponent(new RocketComponent(rocket.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(rocket.MODEL_UPGRADE.getModel().toString()), rocketComponent.fuelType(), Math.max(rocketComponent.fuel(), 0), rocketComponent.getFuelType().getFuelTexture(), rocket.TANK_UPGRADE.getTankCapacity()));
        }
        return rocket;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        if (rocketComponent == null) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.stellaris.rocket.fuel", (Object[])new Object[]{rocketComponent.fuel()}).withStyle(ChatFormatting.GRAY));
    }

    public float getRocketPlaceHigh() {
        return -0.6f;
    }

    public void rocketPlaceSound(BlockPos pos, Level world) {
        world.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected static double getYOffset(LevelReader reader, BlockPos pos, boolean p_20628_, AABB p_20629_) {
        AABB aabb = new AABB(pos);
        if (p_20628_) {
            aabb = aabb.expandTowards(0.0, -1.0, 0.0);
        }
        Iterable iterable = reader.getCollisions(null, aabb);
        return 1.0 + Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)p_20629_, (Iterable)iterable, (double)(p_20628_ ? -2.0 : -1.0));
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        return 13 * rocketComponent.fuel() / rocketComponent.getTankCapacity();
    }

    public int getBarColor(ItemStack stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        FuelType.Type type = rocketComponent.getFuelType();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FUEL", "HYDROGEN", "RADIOACTIVE", "URANIUM", "NEPTUNIUM", "PLUTONIUM"}, (FuelType.Type)type, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> 11003629;
            case 1 -> 55551;
            case 2, 3, 4, 5 -> 49455;
            case -1 -> 11003629;
        };
    }
}

