/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.armors;

import com.fej1fun.potentials.fluid.ItemFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.items.CustomArmorItem;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSpaceArmor
extends CustomArmorItem {
    public AbstractSpaceArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public static class Chestplate
    extends AbstractSpaceChestplate {
        public Chestplate(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
            super(material, type, properties);
        }

        @Override
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            tooltipComponents.add((Component)Component.translatable((String)"jetsuit.stellaris.fuel", (Object[])new Object[]{this.getFluidTank(stack).getFluidInTank(1).getAmount()}));
        }

        @Override
        @NotNull
        public UniversalFluidItemStorage getFluidTank(@NotNull ItemStack stack) {
            return new ItemFluidStorage(this, (DataComponentType)DataComponentsRegistry.FLUID_LIST.get(), stack, 2, 3000L){

                public boolean isFluidValid(int tank, FluidStack stack) {
                    return switch (tank) {
                        case 0 -> stack.getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get());
                        case 1 -> stack.getFluid().isSame((Fluid)FluidRegistry.FUEL_STILL.get());
                        default -> false;
                    };
                }
            };
        }
    }

    public static class AbstractSpaceChestplate
    extends AbstractSpaceArmor
    implements FluidProvider.ITEM {
        public AbstractSpaceChestplate(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
            super(material, type, properties);
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            tooltipComponents.add((Component)Component.translatable((String)"jetsuit.stellaris.oxygen", (Object[])new Object[]{this.getFluidTank(stack).getFluidInTank(0).getAmount()}));
        }

        @NotNull
        public UniversalFluidItemStorage getFluidTank(@NotNull ItemStack stack) {
            return new ItemFluidStorage(this, (DataComponentType)DataComponentsRegistry.FLUID_LIST.get(), stack, 1, 3000L){

                public boolean isFluidValid(int tank, FluidStack stack) {
                    return stack.getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get());
                }
            };
        }
    }
}

