/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FuelRefineryBlockEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.menus.slot.FluidContainerSlot;
import com.st0x0ef.stellaris.common.menus.slot.ResultSlot;
import com.st0x0ef.stellaris.common.menus.slot.SpecificFluidContainerSlot;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.material.Fluid;

public class FuelRefineryMenu
extends BaseContainer {
    private final Container container;
    private final FuelRefineryBlockEntity blockEntity;

    public static FuelRefineryMenu create(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        FuelRefineryBlockEntity blockEntity = (FuelRefineryBlockEntity)inventory.player.level().getBlockEntity(buf.readBlockPos());
        return new FuelRefineryMenu(containerId, inventory, (Container)new SimpleContainer(4), blockEntity);
    }

    public FuelRefineryMenu(int containerId, Inventory inventory, Container container, FuelRefineryBlockEntity blockEntity) {
        super((MenuType)MenuTypesRegistry.FUEL_REFINERY.get(), containerId, 4, inventory, 8, 110);
        this.container = container;
        this.blockEntity = blockEntity;
        this.addSlot(new SpecificFluidContainerSlot(container, (Fluid)FluidRegistry.OIL_STILL.get(), 0, 10, 36, false));
        this.addSlot(new ResultSlot(container, 1, 10, 66));
        this.addSlot(new FluidContainerSlot(container, 2, 125, 36, false, true));
        this.addSlot(new ResultSlot(container, 3, 125, 66));
    }

    @Override
    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public FuelRefineryBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

