/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.fej1fun.potentials.energy.BaseEnergyStorage;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import com.st0x0ef.stellaris.Stellaris;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record SyncEnergyPacket(int energy, BlockPos pos, Direction direction) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncEnergyPacket> TYPE = new CustomPacketPayload.Type(Stellaris.id("energy_sync_packet"));
    public static final StreamCodec<ByteBuf, SyncEnergyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncEnergyPacket::energy, (StreamCodec)BlockPos.STREAM_CODEC, SyncEnergyPacket::pos, (StreamCodec)Direction.STREAM_CODEC, SyncEnergyPacket::direction, SyncEnergyPacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncEnergyPacket data, NetworkManager.PacketContext context) {
        context.queue(() -> {
            EnergyProvider.BLOCK energyProvider;
            UniversalEnergyStorage patt1$temp;
            BlockEntity patt0$temp;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && (patt0$temp = level.getBlockEntity(data.pos)) instanceof EnergyProvider.BLOCK && (patt1$temp = (energyProvider = (EnergyProvider.BLOCK)patt0$temp).getEnergy(data.direction)) instanceof BaseEnergyStorage) {
                BaseEnergyStorage energyStorage = (BaseEnergyStorage)patt1$temp;
                energyStorage.setEnergyStored(data.energy);
            }
        });
    }
}

