/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.registry;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.effects.FoggingScreenEffect;
import com.st0x0ef.stellaris.common.effects.RadioactiveEffect;
import com.st0x0ef.stellaris.common.effects.SandStormEffect;
import com.st0x0ef.stellaris.common.registry.SoundRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;

public class EffectsRegistry {
    private static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((String)"stellaris", (ResourceKey)Registries.MOB_EFFECT);
    public static final ResourceLocation RADIOACTIVE = Stellaris.id("radioactive");
    public static final ResourceLocation SANDSTORM = Stellaris.id("sandstorm");
    public static final ResourceLocation FOGGING_OVERLAY = Stellaris.id("fogging");

    public static void register() {
        EFFECTS.register();
        EFFECTS.register(RADIOACTIVE, () -> new RadioactiveEffect(MobEffectCategory.HARMFUL, 8889187).withSoundOnAdded((SoundEvent)SoundRegistry.RADIOACTIVE.get()));
        EFFECTS.register(SANDSTORM, () -> new SandStormEffect(MobEffectCategory.HARMFUL, 8889187));
        EFFECTS.register(FOGGING_OVERLAY, () -> new FoggingScreenEffect(MobEffectCategory.HARMFUL, 8889187));
    }

    public static Holder<MobEffect> getHolder(ResourceLocation id) {
        Holder holder = EFFECTS.getRegistrar().getHolder(id);
        if (holder == null) {
            throw new IllegalArgumentException("MobEffect with id " + String.valueOf(id) + " does not exist");
        }
        return holder;
    }
}

