/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.info.GalaxyInfo;
import com.st0x0ef.stellaris.common.menus.GalaxyMenu;
import com.st0x0ef.stellaris.common.network.packets.OpenPlanetScreenPacket;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_8710;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class GalaxyScreen
extends class_465<GalaxyMenu> {
    public static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/galaxy_selection.png");
    public static final List<GalaxyInfo> GALAXY = new ArrayList<GalaxyInfo>();
    public static float rotationAngle = 0.0f;
    public static boolean isPausePressed = false;
    private int selectedGalaxyIndex = 0;
    int tbtWidth;
    int tbtHeight;
    int tbtX;
    int tbtY;

    public GalaxyScreen(GalaxyMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.field_2792 = 1200;
        this.field_2779 = 1600;
    }

    protected void method_25426() {
        super.method_25426();
        this.tbtWidth = 32;
        this.tbtHeight = 32;
        this.tbtX = this.field_22789 - this.tbtWidth - 10;
        this.tbtY = this.field_22790 - this.tbtHeight - 10;
        isPausePressed = false;
        Object button = new TexturedButton(this.tbtX, this.tbtY, this.tbtWidth, this.tbtHeight, (class_2561)class_2561.method_43471((String)"stellaris.gui.travel_to_planet"), btn -> {
            class_310.method_1551().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
            NetworkManager.sendToServer((class_8710)new OpenPlanetScreenPacket(GALAXY.get(this.selectedGalaxyIndex).id()));
        }).tex(class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/arrow_button.png"), class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/arrow_button_hover.png"));
        this.method_37063((class_364)button);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        guiGraphics.method_25290(BACKGROUND_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.renderSelectedGalaxy(graphics, partialTicks);
    }

    public void method_25419() {
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((class_312)class_310.method_1551().field_1729).method_1598(arg_0, arg_1, arg_2));
        super.method_25419();
        if (((GalaxyMenu)this.field_2797).getPlayer().stellaris$isPlanetMenuOpen()) {
            NetworkManager.sendToServer((class_8710)new OpenPlanetScreenPacket(GALAXY.get(this.selectedGalaxyIndex).id()));
        }
    }

    public static GalaxyInfo findByNameGalaxy(String id) {
        for (GalaxyInfo body : GALAXY) {
            if (!body.id().equals(id)) continue;
            return body;
        }
        Stellaris.LOG.warn("Galaxy not found : {}", (Object)id);
        return null;
    }

    private void renderSelectedGalaxy(class_332 guiGraphics, float partialTicks) {
        class_327 font = class_310.method_1551().field_1772;
        int galaxyWidth = 192;
        int galaxyHeight = 192;
        int galaxyX = (this.field_22789 - galaxyWidth) / 2;
        int galaxyY = (this.field_22790 - galaxyHeight) / 2;
        if (!isPausePressed) {
            rotationAngle -= partialTicks * 0.005f;
        }
        if (!GALAXY.isEmpty()) {
            GalaxyInfo selectedGalaxy = GALAXY.get(this.selectedGalaxyIndex);
            ScreenHelper.drawTexturewithRotation(guiGraphics, selectedGalaxy.texture(), galaxyX, galaxyY, 0, 0, galaxyWidth, galaxyHeight, galaxyWidth, galaxyHeight, rotationAngle);
            int nameWidth = font.method_27525((class_5348)selectedGalaxy.getTranslatable());
            guiGraphics.method_27535(font, selectedGalaxy.getTranslatable(), (this.field_22789 - nameWidth) / 2, 10, 0xFFFFFF);
            String infoText = "You can change the galaxies with \u2190 \u2192";
            int infoWidth = font.method_1727(infoText);
            guiGraphics.method_25303(font, infoText, (this.field_22789 - infoWidth) / 2, this.field_22790 - 30, 0xAAAAAA);
        } else {
            String noGalaxy = "No Galaxies";
            int nameWidth = font.method_1727(noGalaxy);
            guiGraphics.method_25303(font, noGalaxy, (this.field_22789 - nameWidth) / 2, 10, 0xFFFFFF);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            if (!GALAXY.isEmpty()) {
                this.selectedGalaxyIndex = (this.selectedGalaxyIndex - 1 + GALAXY.size()) % GALAXY.size();
            }
            return true;
        }
        if (keyCode == 262) {
            if (!GALAXY.isEmpty()) {
                this.selectedGalaxyIndex = (this.selectedGalaxyIndex + 1) % GALAXY.size();
            }
            return true;
        }
        if (keyCode == 88) {
            isPausePressed = !isPausePressed;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

