/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.windows.LaunchWindow;
import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_6382;
import net.minecraft.class_7528;
import org.joml.Vector4i;

public class LaunchPadsList
extends class_7528 {
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60655((String)"stellaris", (String)"util/scroller");
    public Map<Vector4i, LaunchPadWidget> launchPadMap = new HashMap<Vector4i, LaunchPadWidget>();
    private final AtomicInteger finalHeight = new AtomicInteger(0);
    private final LaunchWindow window;
    public ArrayList<LaunchPad> launchPads;

    public LaunchPadsList(int x, int y, int width, int height, class_2561 message, LaunchWindow window, ArrayList<LaunchPad> launchPads) {
        super(x, y, width, height, message);
        this.window = window;
        this.launchPads = launchPads;
    }

    protected int method_44391() {
        return this.finalHeight.get() - this.finalHeight.get() / 3;
    }

    protected void method_52233(class_332 guiGraphics, int x, int y, int width, int height) {
    }

    protected double method_44393() {
        return 9.0;
    }

    protected void method_44389(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.finalHeight.set(0);
        for (int i = 0; i < this.launchPads.size(); ++i) {
            int x = this.window.getWindowX() + 40;
            int y = i * 35;
            LaunchPadWidget launchPadWidget = new LaunchPadWidget(this.launchPads.get(i), x, this.method_46427() + y, this.window);
            launchPadWidget.render(guiGraphics, mouseX, (int)((double)mouseY + this.method_44387()), partialTick);
            this.launchPadMap.putIfAbsent(launchPadWidget.buttonPositions, launchPadWidget);
            this.finalHeight.addAndGet(y);
        }
    }

    public boolean method_49606() {
        return super.method_49606();
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public void method_44396(class_332 guiGraphics) {
        int i = this.method_44394();
        int j = this.method_46426() + this.field_22758;
        int k = Math.max(this.method_46427(), (int)this.method_44387() * (this.field_22759 - i) / this.method_44390() + this.method_46427());
        RenderSystem.enableBlend();
        guiGraphics.method_52706(SCROLLER_SPRITE, j, k, 8, i);
        RenderSystem.disableBlend();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.launchPadMap != null) {
            for (Map.Entry<Vector4i, LaunchPadWidget> entry : this.launchPadMap.entrySet()) {
                Vector4i pos = entry.getKey();
                LaunchPad launchPad = entry.getValue().launchPad;
                class_5321<class_1937> dimension = launchPad.dimension();
                if (!Utils.isHoveredOnSprite(pos.x, (int)((double)pos.y - this.method_44387()), pos.z, pos.w, (int)mouseX, (int)mouseY) || this.window.parent.windowIndex == -1) continue;
                if (PlanetUtil.isPlanet(dimension.method_29177())) {
                    if (this.window.parent.canLaunch(PlanetUtil.getPlanet(dimension.method_29177()))) {
                        this.window.parent.tpToFocusedPlanet(launchPad.position(), dimension.method_29177());
                    }
                } else if (PlanetUtil.isOrbit(dimension.method_29177()) && this.window.parent.canLaunch(PlanetUtil.getPlanetFromOrbit(dimension.method_29177()))) {
                    this.window.parent.tpToFocusedPlanet(launchPad.position(), dimension.method_29177());
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public class_327 getFont() {
        return class_310.method_1551().field_1772;
    }

    public static class LaunchPadWidget {
        public final LaunchPad launchPad;
        public final int x;
        public final int y;
        public final MoveableWindow window;
        public boolean flames;
        public Vector4i buttonPositions = new Vector4i();
        public TexturedButton launchButton;

        public LaunchPadWidget(LaunchPad launchPad, int x, int y, MoveableWindow window) {
            this.x = x;
            this.y = y;
            this.launchPad = launchPad;
            this.window = window;
            this.flames = new Random().nextInt() == 1;
            this.launchButton = new TexturedButton(this.x + window.method_25368() - 147, this.y + 5, 60, 20, (class_2561)class_2561.method_43470((String)"Launch"), btn -> {});
        }

        public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_52706(GUISprites.WINDOW_BAR, this.x, this.y, this.window.method_25368() - 80, 30);
            String smallPadName = this.launchPad.name().length() > 20 ? this.launchPad.name().substring(0, 20) + "..." : this.launchPad.name();
            guiGraphics.method_25303(this.getFont(), smallPadName, this.x + 10, this.y + 10, Utils.getColorHexCode("white"));
            this.buttonPositions = new Vector4i(this.launchButton.method_46426(), this.launchButton.method_46427(), 50, 15);
            this.launchButton.tex(class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button.png"), class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button_hovered.png"));
            this.launchButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (this.launchButton.method_49606()) {
                // empty if block
            }
            if (this.launchButton.method_49606() && this.flames) {
                guiGraphics.method_52706(GUISprites.FLAMES, this.launchButton.method_46426() - 9, this.launchButton.method_46427() - 17, this.launchButton.method_25368() + 13, this.launchButton.method_25364() + 5);
            }
        }

        public class_327 getFont() {
            return class_310.method_1551().field_1772;
        }
    }
}

