/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.windows;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.components.LaunchPadsList;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import com.st0x0ef.stellaris.client.screens.windows.SpaceStationWindow;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadUtils;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7919;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class LaunchWindow
extends MoveableWindow {
    public final ArrayList<TexturedButton> spaceStationButtons = new ArrayList();
    public final PlanetSelectionScreen parent;
    @Nullable
    public CelestialBody celestialBody;
    public TexturedButton spaceStationButton;
    private LaunchPadsList padsList;
    private String errorMessage = this.getErrorMessage();

    public LaunchWindow(int width, int height, class_2561 message, PlanetSelectionScreen parent) {
        super(width, height, message, (class_437)parent);
        this.parent = parent;
        this.moveLimit = 15;
    }

    @Override
    public void init() {
        GLFW.glfwSetScrollCallback((long)class_310.method_1551().method_22683().method_4490(), (arg_0, arg_1, arg_2) -> ((class_312)class_310.method_1551().field_1729).method_1598(arg_0, arg_1, arg_2));
        this.padsList = new LaunchPadsList(this.getWindowX() + 40, this.getWindowY() + 60, this.method_25368() - 80, this.method_25364() - 90, (class_2561)class_2561.method_43471((String)"gui.stellaris.launchpads"), this, new ArrayList<LaunchPad>());
        this.addWidget(this.padsList);
        this.spaceStationButton = new TexturedButton(this.getWindowX() + this.method_25368() / 2 + 73, this.getWindowY() + 18, 28, 18, (class_2561)class_2561.method_43470((String)""), button -> {
            if (this.celestialBody != null) {
                this.parent.setWindowVisible(1);
                ((SpaceStationWindow)this.parent.moveableWindows.get(1)).setCelestialBody(this.celestialBody);
            }
        }).tex(ResourceLocationUtils.id("textures/gui/util/buttons/space_station_button.png"), ResourceLocationUtils.id("textures/gui/util/buttons/space_station_button_hover.png"));
        this.spaceStationButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Space Stations")));
        this.addWidget(this.spaceStationButton);
    }

    @Override
    public void renderWindow(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        this.padsList.launchPads = this.getLaunchPadsForDimension();
        guiGraphics.method_25290(class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/window/window_large.png"), this.getWindowX(), this.getWindowY(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
        if (this.celestialBody != null && PlanetUtil.getPlanet(this.celestialBody.dimension) != null) {
            this.spaceStationButton.field_22764 = this.celestialBody.spaceStation;
            Planet planet = PlanetUtil.getPlanet(this.celestialBody.dimension);
            guiGraphics.method_25300(class_310.method_1551().field_1772, this.celestialBody.name + " Launch Points", this.getWindowX() + this.method_25368() / 2, this.getWindowY() + 23, -1);
            guiGraphics.method_27534(class_310.method_1551().field_1772, (class_2561)PlanetUtil.getInLinePlanetInfo(planet), this.getWindowX() + this.method_25368() / 2, this.padsList.method_46427() - 12, -1);
            if (!this.parent.canLaunch(planet)) {
                guiGraphics.method_25300(class_310.method_1551().field_1772, "You cannot launch to this planet!", this.getWindowX() + this.method_25368() / 2, this.getWindowY() + this.method_25364() - 26, -65536);
            }
            if (this.padsList.launchPads.isEmpty()) {
                guiGraphics.method_25300(class_310.method_1551().field_1772, this.errorMessage, this.getWindowX() + this.method_25368() / 2, this.padsList.method_46427() + 7, Utils.getColorHexCode("white"));
            }
        }
        guiGraphics.method_51452();
        this.parent.dragging = false;
    }

    @Override
    public void close() {
        GLFW.glfwSetScrollCallback((long)class_310.method_1551().method_22683().method_4490(), this.parent::onMouseScroll);
        this.parent.canZoom = true;
        super.close();
    }

    @Override
    public Consumer<MoveableWindow> resize(class_310 minecraft, int width, int height) {
        CelestialBody body = this.celestialBody;
        return window -> {
            if (window instanceof LaunchWindow) {
                LaunchWindow launchWindow = (LaunchWindow)((Object)window);
                launchWindow.setCelestialBody(body);
                launchWindow.setCelestialBody(body);
                launchWindow.init();
            }
        };
    }

    public void setCelestialBody(@Nullable CelestialBody celestialBody) {
        this.celestialBody = celestialBody;
    }

    public ArrayList<LaunchPad> getLaunchPadsForDimension() {
        Planet planet;
        ArrayList<LaunchPad> launchPads = new ArrayList<LaunchPad>();
        if (this.celestialBody == null) {
            return launchPads;
        }
        if (this.celestialBody.canLaunchOn || this.parent.getPlayer().method_7337()) {
            launchPads.add(this.addDirectLaunch());
        }
        if ((planet = PlanetUtil.getPlanet(this.celestialBody.dimension)) == null) {
            return launchPads;
        }
        PlanetSelectionScreen.LAUNCH_PADS.launchPads().stream().filter(pad -> pad.dimension().method_29177().equals((Object)planet.dimension()) || planet.orbit().isPresent() && pad.dimension().method_29177().equals((Object)planet.orbit().get())).filter(pad -> LaunchPadUtils.canPlayerJoinLaunchPad(pad, this.parent.getPlayer())).forEach(launchPads::add);
        return launchPads;
    }

    public LaunchPad addDirectLaunch() {
        class_1657 player = this.parent.getPlayer();
        return new LaunchPad(10000, this.parent.getPlayer().method_19538(), (class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.celestialBody.dimension), "Launch Directly", true, player.method_5477().getString(), List.of());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.close();
            return false;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void changeVisibility(boolean visible) {
        super.changeVisibility(visible);
        for (TexturedButton button : this.spaceStationButtons) {
            button.field_22764 = visible;
        }
    }

    public String getErrorMessage() {
        double randomNumber = Math.random() * 100.0 + 1.0;
        if (randomNumber < 55.0) {
            return "No Launch Pads available";
        }
        if (randomNumber < 99.0) {
            return "Error 404: Launchpads not found";
        }
        return "These are not the Launchpads you are looking for";
    }

    @Override
    public int getMoveLimit() {
        return 15;
    }
}

