/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseGeneratorBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.DieselGeneratorBlock;
import com.st0x0ef.stellaris.common.menus.DieselGeneratorMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacketWithoutDirection;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.energy.EnergyUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class DieselGeneratorBlockEntity
extends BaseGeneratorBlockEntity
implements FluidProvider.BLOCK {
    private int litTime;
    private int litDuration;
    private final SingleFluidStorage dieselTank = new SingleFluidStorage(12800L, 12800L, 12800L){

        @Override
        protected void onChange() {
            DieselGeneratorBlockEntity.this.method_5431();
            if (DieselGeneratorBlockEntity.this.field_11863 != null && DieselGeneratorBlockEntity.this.field_11863.method_8503() != null && !DieselGeneratorBlockEntity.this.field_11863.method_8503().method_3760().method_14571().isEmpty()) {
                NetworkManager.sendToPlayers((Iterable)DieselGeneratorBlockEntity.this.field_11863.method_8503().method_3760().method_14571(), (class_8710)new SyncFluidPacketWithoutDirection(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, DieselGeneratorBlockEntity.this.method_11016()));
            }
        }

        @Override
        public boolean isFluidValid(int tank, FluidStack stack) {
            return stack.getFluid().method_15780((class_3611)FluidRegistry.DIESEL_STILL.get());
        }
    };

    public DieselGeneratorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(BlockEntityRegistry.DIESEL_GENERATOR.get(), blockPos, blockState, 10, 12800);
    }

    public DieselGeneratorBlockEntity(class_2591<?> entityType, class_2338 blockPos, class_2680 blockState, int energyGeneratedPT, int maxCapacity) {
        super(entityType, blockPos, blockState, energyGeneratedPT, maxCapacity);
    }

    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new DieselGeneratorMenu(containerId, inventory, (class_1263)this, this);
    }

    @Override
    public void tick() {
        boolean wasLit = this.isLit();
        boolean shouldUpdate = false;
        if (this.canGenerate()) {
            --this.litTime;
        }
        FluidUtil.moveFluidFromItem(0, 0, (class_2371<class_1799>)this.items, this.dieselTank, 1000L);
        if (!this.dieselTank.isEmpty() && this.litTime <= 0) {
            int fuelTime;
            this.litDuration = fuelTime = Stellaris.CONFIG.dieselGeneratorFuelTime;
            this.litTime = fuelTime;
            if (this.isLit()) {
                this.dieselTank.drain(FluidStack.create((class_3611)((class_3611)FluidRegistry.DIESEL_STILL.get()), (long)5L), false);
                this.energyContainer.insert(this.energyGeneratedPT, false);
                shouldUpdate = true;
            }
        }
        if (wasLit != this.isLit()) {
            shouldUpdate = true;
            class_2680 state = (class_2680)this.method_11010().method_11657((class_2769)DieselGeneratorBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            this.field_11863.method_8652(this.method_11016(), state, 3);
        }
        if (shouldUpdate) {
            this.method_5431();
        }
        EnergyUtil.distributeEnergyNearby(this.field_11863, this.field_11867, this.maxCapacity);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public boolean canGenerate() {
        boolean isMaxEnergy = this.energyContainer.getEnergy() == this.energyContainer.getMaxEnergy();
        return this.isLit() && !isMaxEnergy;
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.litTime = tag.method_10568("BurnTime");
        this.dieselTank.load(tag, provider, "diesel");
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10575("BurnTime", (short)this.litTime);
        this.dieselTank.save(tag, provider, "diesel");
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.stellaris.diesel_generator");
    }

    @Override
    public int method_5439() {
        return 2;
    }

    public SingleFluidStorage getDieselTank() {
        return this.dieselTank;
    }

    @Nullable
    public UniversalFluidStorage getFluidTank(@Nullable class_2350 direction) {
        return this.dieselTank;
    }
}

