/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles;

import com.st0x0ef.stellaris.common.data_components.RoverComponent;
import com.st0x0ef.stellaris.common.entities.vehicles.base.AbstractRoverBase;
import com.st0x0ef.stellaris.common.items.VehicleUpgradeItem;
import com.st0x0ef.stellaris.common.menus.RoverMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncRoverComponentPacket;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SpeedUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.VehicleUpgrade;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import net.minecraft.class_8710;
import net.minecraft.class_9331;
import org.joml.Vector3d;

public class RoverEntity
extends AbstractRoverBase
implements class_7248,
class_1265 {
    public MotorUpgrade motorUpgrade;
    public TankUpgrade tankUpgrade;
    public SpeedUpgrade speedUpgrade;
    public final class_1277 inventory = new class_1277(13);
    public RoverComponent roverComponent;

    public RoverEntity(class_1299 type, class_1937 worldIn) {
        super(type, worldIn);
        this.motorUpgrade = MotorUpgrade.getBasic(false);
        this.tankUpgrade = TankUpgrade.getBasic();
        this.speedUpgrade = SpeedUpgrade.getBasic();
        this.FUEL = 0;
        this.FUEL_TYPE = FuelType.Type.DIESEL;
        this.roverComponent = new RoverComponent(this.FUEL_TYPE.method_15434(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.tankUpgrade.getTankCapacity(), this.speedUpgrade.getSpeedModifier());
    }

    public void setRoverComponent(RoverComponent roverComponent) {
        this.roverComponent = roverComponent;
        this.motorUpgrade = roverComponent.getMotorUpgrade();
        this.tankUpgrade = roverComponent.getTankUpgrade();
        this.speedUpgrade = roverComponent.getSpeedUpgrade();
        this.FUEL = roverComponent.getFuel();
        this.FUEL_TYPE = roverComponent.getFuelType();
    }

    @Override
    public float getMaxSpeed() {
        return 0.8f * this.speedUpgrade.getSpeedModifier();
    }

    @Override
    public float getMaxReverseSpeed() {
        return 0.6f * this.speedUpgrade.getSpeedModifier();
    }

    @Override
    public float getAcceleration() {
        return 1.8f * this.speedUpgrade.getSpeedModifier() * 0.5f / 2.0f;
    }

    @Override
    public float getMaxRotationSpeed() {
        return 6.8f;
    }

    @Override
    public float getMinRotationSpeed() {
        return 4.8f;
    }

    @Override
    public float getRollResistance() {
        return 1.5f;
    }

    @Override
    public float getRotationModifier() {
        return 2.9f;
    }

    @Override
    public float getPitch() {
        return 0.75f;
    }

    @Override
    public double getPlayerYOffset() {
        return 1.0;
    }

    @Override
    public int getPassengerSize() {
        return 2;
    }

    @Override
    public Vector3d[] getPlayerOffsets() {
        return new Vector3d[]{new Vector3d(0.45, 0.5, -0.35), new Vector3d(0.45, 0.5, 0.35)};
    }

    @Override
    public boolean doesEnterThirdPerson() {
        return true;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        super.method_5688(player, hand);
        class_1269 result = class_1269.method_29236((boolean)this.method_37908().field_9236);
        if (!this.method_37908().field_9236) {
            if (player.method_18276()) {
                if (!this.tryFillUpRover(player.method_6047().method_7909())) {
                    this.method_6722(player);
                } else {
                    player.method_5998(hand).method_7933(-1);
                    player.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8550));
                }
                return class_1269.field_21466;
            }
            return class_1269.field_21466;
        }
        return result;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.checkContainer();
        class_1657 class_16572 = this.getDriver();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            this.syncRocketData(serverPlayer);
        }
    }

    @Override
    protected boolean consumeFuel() {
        if (this.getFuel() <= 0) {
            return false;
        }
        --this.FUEL;
        return this.getFuel() >= 0;
    }

    private void checkContainer() {
        VehicleUpgrade upgrade;
        VehicleUpgrade vehicleUpgrade;
        VehicleUpgradeItem item;
        if (this.method_37908().field_9236) {
            return;
        }
        class_1792 class_17922 = this.getInventory().method_5438(2).method_7909();
        if (class_17922 instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)class_17922;
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof MotorUpgrade) {
                this.motorUpgrade = upgrade = (MotorUpgrade)vehicleUpgrade;
            }
        } else if (this.getInventory().method_5438(2).method_7960()) {
            this.motorUpgrade = MotorUpgrade.getBasic(false);
        }
        upgrade = this.getInventory().method_5438(3).method_7909();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof SpeedUpgrade) {
                upgrade = (SpeedUpgrade)vehicleUpgrade;
                this.speedUpgrade = upgrade;
            }
        } else if (this.getInventory().method_5438(3).method_7960()) {
            this.speedUpgrade = SpeedUpgrade.getBasic();
        }
        upgrade = this.getInventory().method_5438(4).method_7909();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof TankUpgrade) {
                upgrade = (TankUpgrade)vehicleUpgrade;
                this.tankUpgrade = upgrade;
            }
        } else if (this.getInventory().method_5438(4).method_7960()) {
            this.tankUpgrade = TankUpgrade.getBasic();
        }
        this.tryFillUpRover(this.getInventory().method_5438(0).method_7909());
    }

    private class_1277 getInventory() {
        return this.inventory;
    }

    public boolean tryFillUpRover(class_1792 item) {
        if (this.method_37908().field_9236) {
            return false;
        }
        if (this.FUEL >= this.tankUpgrade.getTankCapacity() || item == null) {
            return false;
        }
        FuelType.Type itemType = FuelType.Type.getTypeBasedOnItem(item);
        if (itemType == null) {
            return false;
        }
        FuelType.Type motorType = this.motorUpgrade.getFuelType();
        if (motorType == itemType.getMotorType()) {
            if (this.FUEL == 0) {
                this.FUEL_TYPE = itemType;
            }
            if (itemType == this.FUEL_TYPE) {
                class_1799 fuelItem;
                this.FUEL += 1000;
                if (this.FUEL > this.tankUpgrade.getTankCapacity()) {
                    this.FUEL = this.tankUpgrade.getTankCapacity();
                }
                if ((fuelItem = this.inventory.method_5434(0, 1)).method_31574((class_1792)ItemsRegistry.FUEL_BUCKET.get()) || fuelItem.method_31574((class_1792)ItemsRegistry.HYDROGEN_BUCKET.get())) {
                    this.inventory.method_5447(1, new class_1799((class_1935)class_1802.field_8550, this.inventory.method_5438(1).method_7947() + 1));
                }
                return true;
            }
        }
        return false;
    }

    public void method_5768() {
        this.dropEquipment();
        this.spawnRoverItem();
        if (!this.method_37908().field_9236) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity != null && sourceEntity.method_18276() && !this.method_5782()) {
            this.dropEquipment();
            this.spawnRoverItem();
            if (!this.method_37908().field_9236) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
            return true;
        }
        return false;
    }

    public void syncRocketData(class_3222 player) {
        this.roverComponent = new RoverComponent(this.FUEL_TYPE.method_15434(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.tankUpgrade.getTankCapacity(), this.speedUpgrade.getSpeedModifier());
        if (!this.method_37908().method_8608()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SyncRoverComponentPacket(this.roverComponent));
        }
    }

    private void spawnRoverItem() {
        class_1542 entityToSpawn = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.getRoverItem());
        entityToSpawn.method_6982(10);
        entityToSpawn.method_6983().method_57379((class_9331)DataComponentsRegistry.ROVER_COMPONENT.get(), (Object)this.roverComponent);
        this.method_37908().method_8649((class_1297)entityToSpawn);
    }

    private class_1799 getRoverItem() {
        return ((class_1792)ItemsRegistry.ROVER.get()).method_7854();
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.method_54454().size(); ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            this.method_5775(itemstack);
        }
    }

    public void method_5453(class_1263 container) {
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("InventoryCustom", (class_2520)this.inventory.method_7660((class_7225.class_7874)this.method_56673()));
        compound.method_10569("fuel", this.FUEL);
        if (this.FUEL != 0) {
            compound.method_10582("currentFuelItemType", this.FUEL_TYPE.method_15434());
        }
        class_2499 listTag = new class_2499();
        for (int i = 1; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)(i - 1));
            listTag.add((Object)itemStack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)compoundTag));
        }
        compound.method_10566("Items", (class_2520)listTag);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        class_2499 inventoryCustom = compound.method_10554("InventoryCustom", 14);
        this.inventory.method_7659(inventoryCustom, (class_7225.class_7874)this.method_56673());
        this.FUEL = compound.method_10550("fuel");
        if (this.FUEL != 0) {
            this.FUEL_TYPE = FuelType.Type.fromString(compound.method_10558("currentFuelItemType"));
        }
        class_2499 listTag = compound.method_10554("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag = listTag.method_10602(i);
            int j = compoundTag.method_10571("Slot") & 0xFF;
            if (j >= this.inventory.method_5439() - 1) continue;
            this.inventory.method_5447(j + 1, class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)compoundTag).orElse(class_1799.field_8037));
        }
    }

    public void method_6722(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(class_2540 packetByteBuf) {
                    packetByteBuf.method_10804(RoverEntity.this.method_5628());
                }

                public class_2561 method_5476() {
                    return class_2561.method_43470((String)"Rover");
                }

                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    class_2540 packetBuffer = new class_2540(Unpooled.buffer());
                    packetBuffer.method_53002(RoverEntity.this.FUEL);
                    packetBuffer.method_10804(RoverEntity.this.method_5628());
                    return new RoverMenu(syncId, inv, (class_1263)RoverEntity.this.inventory, RoverEntity.this.method_5628());
                }
            });
        }
    }

    public RoverComponent getRoverComponent() {
        return this.roverComponent;
    }
}

