/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles.base;

import com.st0x0ef.stellaris.common.entities.vehicles.IVehicleEntity;
import com.st0x0ef.stellaris.common.network.packets.SyncRoverPacket;
import com.st0x0ef.stellaris.common.utils.MathUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import org.joml.Vector3d;

public abstract class AbstractRoverBase
extends IVehicleEntity {
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;
    private float wheelRotation;
    private boolean collidedLastTick;
    private static final class_2940<Float> SPEED = class_2945.method_12791(AbstractRoverBase.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> FORWARD = class_2945.method_12791(AbstractRoverBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BACKWARD = class_2945.method_12791(AbstractRoverBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LEFT = class_2945.method_12791(AbstractRoverBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> RIGHT = class_2945.method_12791(AbstractRoverBase.class, (class_2941)class_2943.field_13323);
    private final float distanceBetweenFuelConsumption = 20.0f;
    private float distanceBeforeNextFuelConsumption = 0.0f;
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();

    public AbstractRoverBase(class_1299 type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_23807 = true;
        this.recalculateBoundingBox();
    }

    public abstract float getMaxSpeed();

    public abstract float getMaxReverseSpeed();

    public abstract float getAcceleration();

    public abstract float getMaxRotationSpeed();

    public abstract float getMinRotationSpeed();

    public abstract float getRollResistance();

    public abstract float getRotationModifier();

    public abstract float getPitch();

    @Override
    public void method_5773() {
        Runnable task;
        super.method_5773();
        while ((task = (Runnable)this.tasks.poll()) != null) {
            task.run();
        }
        this.updateGravity();
        this.controlRover();
        this.checkPush();
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (!this.method_37908().field_9236) {
            this.field_6014 = this.method_23317();
            this.field_6036 = this.method_23318();
            this.field_5969 = this.method_23321();
        }
        this.updateWheelRotation();
        this.tickLerp();
    }

    public void centerCar() {
        class_2350 facing = this.method_5735();
        switch (facing) {
            case field_11035: {
                this.method_36456(0.0f);
                break;
            }
            case field_11043: {
                this.method_36456(180.0f);
                break;
            }
            case field_11034: {
                this.method_36456(-90.0f);
                break;
            }
            case field_11039: {
                this.method_36456(90.0f);
            }
        }
    }

    public boolean method_30949(class_1297 entityIn) {
        float speed;
        if (!this.method_37908().field_9236 && entityIn instanceof class_1309 && !this.method_5685().contains(entityIn) && entityIn.method_5829().method_994(this.method_5829()) && (speed = this.getSpeed()) > 0.35f) {
            float damage = speed * 10.0f;
            this.tasks.add(() -> {
                class_3218 serverLevel = (class_3218)this.method_37908();
                Optional holder = serverLevel.method_30349().method_30530(class_7924.field_42534).method_40264(class_8111.field_42342);
                holder.ifPresent(damageTypeReference -> entityIn.method_5643(new class_1282((class_6880)damageTypeReference, (class_1297)this), damage));
            });
        }
        return (entityIn.method_30948() || entityIn.method_5810()) && !this.method_5794(entityIn);
    }

    public void checkPush() {
        List list = this.method_37908().method_18467(class_1657.class, this.method_5829().method_1012(0.2, 0.0, 0.2).method_1012(-0.2, 0.0, -0.2));
        for (class_1657 player : list) {
            if (player.method_5626((class_1297)this) || !player.method_5715()) continue;
            double motX = AbstractRoverBase.calculateMotionX(0.05f, player.method_36454());
            double motZ = AbstractRoverBase.calculateMotionZ(0.05f, player.method_36454());
            this.method_5784(class_1313.field_6305, new class_243(motX, 0.0, motZ));
            return;
        }
    }

    public void controlRover() {
        if (!this.method_5782()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
            return;
        }
        if (this.distanceBeforeNextFuelConsumption <= 0.0f) {
            if (!this.consumeFuel()) {
                return;
            }
            this.distanceBeforeNextFuelConsumption = 20.0f;
        }
        float speed = this.getRoverSpeed(0.5f);
        this.setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = class_3532.method_15379((float)(this.getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = class_3532.method_15363((float)rotationSpeed, (float)this.getMinRotationSpeed(), (float)this.getMaxRotationSpeed());
        }
        this.deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.deltaRotation = class_3532.method_15363((float)this.deltaRotation, (float)-45.0f, (float)45.0f);
        this.method_36456(this.method_36454() + this.deltaRotation);
        float delta = Math.abs(this.method_36454() - this.field_5982);
        while (this.method_36454() > 180.0f) {
            this.method_36456(this.method_36454() - 360.0f);
            this.field_5982 = this.method_36454() - delta;
        }
        while (this.method_36454() <= -180.0f) {
            this.method_36456(this.method_36454() + 360.0f);
            this.field_5982 = delta + this.method_36454();
        }
        if (this.field_5976) {
            if (this.method_37908().field_9236 && !this.collidedLastTick) {
                this.onCollision(speed);
                this.collidedLastTick = true;
            }
        } else {
            this.method_18800(AbstractRoverBase.calculateMotionX(this.getSpeed(), this.method_36454()), this.method_18798().field_1351, AbstractRoverBase.calculateMotionZ(this.getSpeed(), this.method_36454()));
            if (this.method_37908().field_9236) {
                this.collidedLastTick = false;
            }
        }
        if (this.isForward() || this.isBackward()) {
            this.distanceBeforeNextFuelConsumption -= Math.abs(this.getSpeed());
        }
    }

    private float getRoverSpeed(float modifier) {
        float maxSp = this.getMaxSpeed() * modifier;
        float maxBackSp = this.getMaxReverseSpeed() * modifier;
        float speed = MathUtils.subtractToZero(this.getSpeed(), this.getRollResistance());
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.getAcceleration(), maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.getAcceleration(), -maxBackSp);
        }
        return speed;
    }

    protected abstract boolean consumeFuel();

    public void onCollision(float speed) {
        this.setSpeed(0.01f);
        this.method_18800(0.0, this.method_18798().field_1351, 0.0);
    }

    public boolean canPlayerDriveCar(class_1657 player) {
        if (player.equals((Object)this.getDriver())) {
            return true;
        }
        if (this.method_5799() || this.method_5771()) {
            return false;
        }
        return false;
    }

    private void updateGravity() {
        if (this.method_5740()) {
            this.method_18800(this.method_18798().field_1352, 0.0, this.method_18798().field_1350);
            return;
        }
        this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 - 0.2, this.method_18798().field_1350);
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, class_1657 player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.method_37908().field_9236 && needsUpdate) {
            NetworkManager.sendToServer((class_8710)new SyncRoverPacket(forward, backward, left, right, player));
        }
    }

    public abstract double getPlayerYOffset();

    public boolean canPlayerEnterCar(class_1657 player) {
        return true;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_5715()) {
            if (player.method_5854() != this && !this.method_37908().field_9236) {
                player.method_5804((class_1297)this);
            }
            return class_1269.field_5812;
        }
        if (!this.canPlayerEnterCar(player)) {
            return class_1269.field_5814;
        }
        return super.method_5688(player, hand);
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float getWheelRotationAmount() {
        return 120.0f * this.getSpeed();
    }

    public void updateWheelRotation() {
        this.wheelRotation += this.getWheelRotationAmount();
    }

    public float getWheelRotation(float partialTicks) {
        return this.wheelRotation + this.getWheelRotationAmount() * partialTicks;
    }

    public boolean isAccelerating() {
        return (this.isForward() || this.isBackward()) && !this.field_5976;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SPEED, (Object)Float.valueOf(0.0f));
        builder.method_56912(FORWARD, (Object)false);
        builder.method_56912(BACKWARD, (Object)false);
        builder.method_56912(LEFT, (Object)false);
        builder.method_56912(RIGHT, (Object)false);
    }

    @Override
    public void setSpeed(float speed) {
        this.field_6011.method_12778(SPEED, (Object)Float.valueOf(speed));
    }

    @Override
    public float getSpeed() {
        return ((Float)this.field_6011.method_12789(SPEED)).floatValue();
    }

    public void setForward(boolean forward) {
        this.field_6011.method_12778(FORWARD, (Object)forward);
    }

    public boolean isForward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_6011.method_12789(FORWARD);
    }

    public void setBackward(boolean backward) {
        this.field_6011.method_12778(BACKWARD, (Object)backward);
    }

    public boolean isBackward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_6011.method_12789(BACKWARD);
    }

    public void setLeft(boolean left) {
        this.field_6011.method_12778(LEFT, (Object)left);
    }

    public boolean isLeft() {
        return (Boolean)this.field_6011.method_12789(LEFT);
    }

    public void setRight(boolean right) {
        this.field_6011.method_12778(RIGHT, (Object)right);
    }

    public boolean isRight() {
        return (Boolean)this.field_6011.method_12789(RIGHT);
    }

    public void method_5749(class_2487 compound) {
    }

    protected void method_5652(class_2487 compound) {
    }

    public float method_49476() {
        return 1.0f;
    }

    public void recalculateBoundingBox() {
        double width = this.getCarWidth();
        double height = this.getCarHeight();
        this.method_5857(new class_238(this.method_23317() - width / 2.0, this.method_23318(), this.method_23321() - width / 2.0, this.method_23317() + width / 2.0, this.method_23318() + height, this.method_23321() + width / 2.0));
    }

    public double getCarWidth() {
        return 1.3;
    }

    public double getCarHeight() {
        return 1.6;
    }

    public class_1657 getDriver() {
        List passengers = this.method_5685();
        if (passengers.isEmpty()) {
            return null;
        }
        if (passengers.getFirst() instanceof class_1657) {
            return (class_1657)passengers.getFirst();
        }
        return null;
    }

    public abstract int getPassengerSize();

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < this.getPassengerSize();
    }

    protected void applyYawToEntity(class_1297 entityToUpdate) {
        entityToUpdate.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entityToUpdate.method_36454() - this.method_36454()));
        float f1 = class_3532.method_15363((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.field_5982 += f1 - f;
        entityToUpdate.method_36456(entityToUpdate.method_36454() + f1 - f);
        entityToUpdate.method_5847(entityToUpdate.method_36454());
    }

    public void method_5644(class_1297 entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public abstract Vector3d[] getPlayerOffsets();

    public void method_5865(class_1297 passenger, class_1297.class_4738 moveFunction) {
        if (!this.method_5626(passenger)) {
            return;
        }
        double front = 0.0;
        double side = 0.0;
        double height = 0.0;
        List passengers = this.method_5685();
        if (!passengers.isEmpty()) {
            int i = passengers.indexOf(passenger);
            Vector3d offset = this.getPlayerOffsets()[i];
            front = offset.x;
            side = offset.z;
            height = offset.y;
        }
        class_243 vec3d = new class_243(front, height, side).method_1024(-this.method_36454() * ((float)Math.PI / 180) - 1.5707964f);
        passenger.method_5814(this.method_23317() + vec3d.field_1352, this.method_23318() + vec3d.field_1351, this.method_23321() + vec3d.field_1350);
        passenger.method_36456(passenger.method_36454() + this.deltaRotation);
        passenger.method_5847(passenger.method_5791() + this.deltaRotation);
        this.applyYawToEntity(passenger);
    }

    public class_1309 method_5642() {
        return this.getDriver();
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_5810() {
        return true;
    }

    @Override
    public boolean method_5863() {
        return this.method_5805();
    }

    private void tickLerp() {
        if (this.method_5787()) {
            this.steps = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.steps > 0) {
            double d0 = this.method_23317() + (this.clientX - this.method_23317()) / (double)this.steps;
            double d1 = this.method_23318() + (this.clientY - this.method_23318()) / (double)this.steps;
            double d2 = this.method_23321() + (this.clientZ - this.method_23321()) / (double)this.steps;
            double d3 = class_3532.method_15338((double)(this.clientYaw - (double)this.method_36454()));
            this.method_36456((float)((double)this.method_36454() + d3 / (double)this.steps));
            this.method_36457((float)((double)this.method_36455() + (this.clientPitch - (double)this.method_36455()) / (double)this.steps));
            --this.steps;
            this.method_5814(d0, d1, d2);
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    @Override
    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static double calculateMotionX(float speed, float rotationYaw) {
        return class_3532.method_15374((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static double calculateMotionZ(float speed, float rotationYaw) {
        return class_3532.method_15362((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public abstract boolean doesEnterThirdPerson();

    public class_243 method_24829(class_1309 entity) {
        class_2350 direction = this.method_5755();
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return super.method_24829(entity);
        }
        int[][] offsets = class_5275.method_27934((class_2350)direction);
        class_238 bb = entity.method_24833(class_4050.field_18076);
        class_238 carBB = this.method_5829();
        for (int[] offset : offsets) {
            class_243 dismountPos = new class_243(this.method_23317() + (double)offset[0] * (carBB.method_17939() / 2.0 + bb.method_17939() / 2.0 + 0.0625), this.method_23318(), this.method_23321() + (double)offset[1] * (carBB.method_17939() / 2.0 + bb.method_17939() / 2.0 + 0.0625));
            double y = this.method_37908().method_30347(new class_2338((int)dismountPos.field_1352, (int)dismountPos.field_1351, (int)dismountPos.field_1350));
            if (!class_5275.method_27932((double)y) || !class_5275.method_27933((class_1941)this.method_37908(), (class_1309)entity, (class_238)bb.method_997(dismountPos))) continue;
            return dismountPos;
        }
        return super.method_24829(entity);
    }
}

