/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.events;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.CoalLanternBlock;
import com.st0x0ef.stellaris.common.blocks.RocketLaunchPad;
import com.st0x0ef.stellaris.common.blocks.WallCoalTorchBlock;
import com.st0x0ef.stellaris.common.blocks.entities.machines.AntennaBlockEntity;
import com.st0x0ef.stellaris.common.data_components.RadioactiveComponent;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadLauncher;
import com.st0x0ef.stellaris.common.network.packets.SyncLaunchPads;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3749;
import net.minecraft.class_8710;
import net.minecraft.class_9331;

public class Events {
    private static final int RADIATION_CHECK_INTERVAL;
    private static int tickBeforeNextRadioactiveCheck;

    public static void registerEvents() {
        TickEvent.PLAYER_POST.register(player -> {
            if (!player.method_37908().method_8608()) {
                if (tickBeforeNextRadioactiveCheck <= 0 && !Utils.isLivingInJetSuit((class_1309)player)) {
                    int level = player.method_31548().field_7547.stream().filter(stack -> stack.method_57826((class_9331)DataComponentsRegistry.RADIOACTIVE.get())).mapToInt(stack -> ((RadioactiveComponent)stack.method_57824((class_9331)DataComponentsRegistry.RADIOACTIVE.get())).level()).max().orElse(-1);
                    if (level >= 0) {
                        player.method_6092(new class_1293(EffectsRegistry.getHolder(EffectsRegistry.RADIOACTIVE), 100, level));
                    }
                    tickBeforeNextRadioactiveCheck = RADIATION_CHECK_INTERVAL;
                }
                --tickBeforeNextRadioactiveCheck;
            }
        });
        BlockEvent.BREAK.register((level, pos, state, player, value) -> {
            if (level instanceof class_3218) {
                AntennaBlockEntity antennaBlockEntity;
                class_3218 serverLevel = (class_3218)level;
                if (state.method_53257(BlocksRegistry.OXYGEN_DISTRIBUTOR)) {
                    GlobalOxygenManager.getInstance().getOrCreateDimensionManager(serverLevel).removeOxygenRoom(pos);
                } else if (state.method_53257(BlocksRegistry.ROCKET_LAUNCH_PAD)) {
                    if (Events.checkIfAntennaIsNear(pos, level)) {
                        return EventResult.interruptFalse();
                    }
                } else if (state.method_53257(BlocksRegistry.ANTENNA) && (antennaBlockEntity = (AntennaBlockEntity)level.method_8321(pos)) != null && antennaBlockEntity.launchPadId != -1) {
                    LaunchPadLauncher.removeLaunchpad(antennaBlockEntity.launchPadId, serverLevel.method_8503());
                }
            }
            return EventResult.pass();
        });
        BlockEvent.PLACE.register((level, pos, state, player) -> {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (!PlanetUtil.hasOxygen(level)) {
                    if (state.method_27852(class_2246.field_10336)) {
                        serverLevel.method_8501(pos, ((class_2248)BlocksRegistry.COAL_TORCH_BLOCK.get()).method_9564());
                        return EventResult.interruptFalse();
                    }
                    if (state.method_27852(class_2246.field_10099)) {
                        serverLevel.method_8501(pos, (class_2680)((class_2248)BlocksRegistry.WALL_COAL_TORCH_BLOCK.get()).method_9564().method_11657((class_2769)WallCoalTorchBlock.FACING, (Comparable)((class_2350)state.method_11654((class_2769)class_2555.field_11731))));
                        return EventResult.interruptFalse();
                    }
                    if (state.method_27852(class_2246.field_16541)) {
                        serverLevel.method_8501(pos, (class_2680)((class_2248)BlocksRegistry.COAL_LANTERN_BLOCK.get()).method_9564().method_11657((class_2769)CoalLanternBlock.field_16545, (Comparable)((Boolean)state.method_11654((class_2769)class_3749.field_16545))));
                        return EventResult.interruptFalse();
                    }
                }
            }
            if (state.method_53257(BlocksRegistry.ANTENNA)) {
                if (level.method_8320(pos.method_10084()).method_53257(BlocksRegistry.ROCKET_LAUNCH_PAD) && ((Boolean)level.method_8320(pos.method_10084()).method_11654((class_2769)RocketLaunchPad.STAGE)).booleanValue()) {
                    return EventResult.pass();
                }
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        LifecycleEvent.SERVER_STARTED.register(server -> {
            class_32.class_5143 levelStorageSource = server.field_23784;
            LaunchPadLauncher.loadOrGenerateDefaults(levelStorageSource.method_54543().comp_732());
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            class_32.class_5143 levelStorageSource = player.field_13995.field_23784;
            LaunchPadLauncher.loadOrGenerateDefaults(levelStorageSource.method_54543().comp_732());
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SyncLaunchPads(LaunchPadLauncher.LAUNCH_PADS));
        });
        TickEvent.SERVER_LEVEL_POST.register(level -> GlobalOxygenManager.getInstance().getOrCreateDimensionManager((class_3218)level).updateOxygenTick());
    }

    private static boolean checkIfAntennaIsNear(class_2338 pos, class_1937 level) {
        return level.method_29546(new class_238(pos).method_1014(1.0)).anyMatch(blockState -> blockState.method_53257(BlocksRegistry.ANTENNA));
    }

    static {
        tickBeforeNextRadioactiveCheck = RADIATION_CHECK_INTERVAL = Stellaris.CONFIG.radiationCheckInterval;
    }
}

