/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.launchpads;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.network.packets.SyncLaunchPads;
import dev.architectury.networking.NetworkManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.class_3518;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class LaunchPadLauncher {
    public static LaunchPad.LaunchPadContainer LAUNCH_PADS;

    public static void loadOrGenerateDefaults(Path worldPath) {
        Path systemsFile = worldPath.resolve("launch-pads.json");
        try {
            BufferedReader reader = Files.newBufferedReader(systemsFile);
            JsonObject jsonElement = class_3518.method_15255((Reader)reader);
            JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"launchpads");
            LAUNCH_PADS = (LaunchPad.LaunchPadContainer)LaunchPad.LaunchPadContainer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        }
        catch (Exception e) {
            if (!(e instanceof NoSuchFileException)) {
                e.printStackTrace();
            }
            try {
                File folder = systemsFile.toFile().getParentFile();
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                LaunchPad.LaunchPadContainer defaults = LaunchPad.LaunchPadContainer.DEFAULT;
                JsonElement jsonElement = LaunchPad.LaunchPadContainer.toJson(defaults);
                String launchpadsFile = Stellaris.GSON.toJson(jsonElement);
                BufferedWriter launchpadsWrite = Files.newBufferedWriter(systemsFile, new OpenOption[0]);
                launchpadsWrite.write(launchpadsFile);
                launchpadsWrite.close();
                LAUNCH_PADS = defaults;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static boolean removeLaunchpad(int id, MinecraftServer server) {
        ArrayList<LaunchPad> launchPads = new ArrayList<LaunchPad>(LAUNCH_PADS.launchPads());
        for (LaunchPad launchpad : launchPads) {
            if (launchpad.id() != id) continue;
            launchPads.remove(launchpad);
            break;
        }
        if (launchPads.equals(LAUNCH_PADS.launchPads())) {
            Stellaris.LOG.error("Launchpad {} not found", (Object)id);
            return false;
        }
        return LaunchPadLauncher.writeLaunchpads(launchPads, server);
    }

    public static boolean addLaunchPad(LaunchPad pad, MinecraftServer server) {
        if (server == null) {
            Stellaris.LOG.error("Server is null");
            return false;
        }
        Stellaris.LOG.error("{} Adding launchpad {}", (Object)pad.id(), (Object)pad.name());
        ArrayList<LaunchPad> launchPads = new ArrayList<LaunchPad>(LAUNCH_PADS.launchPads());
        launchPads.add(pad);
        return LaunchPadLauncher.writeLaunchpads(launchPads, server);
    }

    public static boolean modifyLaunchPad(LaunchPad pad, MinecraftServer server) {
        if (server == null) {
            Stellaris.LOG.error("Server is null");
            return false;
        }
        ArrayList<LaunchPad> launchPads = new ArrayList<LaunchPad>();
        LAUNCH_PADS.launchPads().forEach(lpad -> {
            if (pad.id() == lpad.id()) {
                launchPads.add(pad);
            } else {
                launchPads.add((LaunchPad)lpad);
            }
        });
        return LaunchPadLauncher.writeLaunchpads(launchPads, server);
    }

    public static boolean writeLaunchpads(ArrayList<LaunchPad> launchPads, MinecraftServer server) {
        Path launchpath = server.field_23784.method_54543().comp_732().resolve("launch-pads.json");
        try {
            LAUNCH_PADS = new LaunchPad.LaunchPadContainer(launchPads);
            JsonElement jsonElement = LaunchPad.LaunchPadContainer.toJson(LAUNCH_PADS);
            String launchpadsFile = Stellaris.GSON.toJson(jsonElement);
            BufferedWriter launchpadsWrite = Files.newBufferedWriter(launchpath, new OpenOption[0]);
            launchpadsWrite.write(launchpadsFile);
            launchpadsWrite.close();
        }
        catch (IOException e) {
            Stellaris.LOG.error("Error writing launchpads to file {}", (Object)e.getMessage());
            return false;
        }
        NetworkManager.sendToPlayers((Iterable)server.method_3760().method_14571(), (class_8710)new SyncLaunchPads(LAUNCH_PADS));
        return true;
    }
}

