/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.launchpads;

import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadLauncher;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class LaunchPadUtils {
    public static boolean launchPadHasSameName(LaunchPad launchPad) {
        for (LaunchPad lp : LaunchPadLauncher.LAUNCH_PADS.launchPads()) {
            if (!lp.name().equals(launchPad.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean launchPadExist(LaunchPad launchPad) {
        for (LaunchPad lp : LaunchPadLauncher.LAUNCH_PADS.launchPads()) {
            if (!lp.name().equals(launchPad.name()) || !lp.dimension().equals(launchPad.dimension())) continue;
            return true;
        }
        return false;
    }

    public static boolean launchPadExistInDimension(LaunchPad launchPad, class_5321<class_1937> dimension) {
        for (LaunchPad lp : LaunchPadLauncher.LAUNCH_PADS.launchPads()) {
            if (!lp.name().equals(launchPad.name()) || !lp.dimension().equals(dimension)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPlayerJoinLaunchPad(LaunchPad launchPad, class_1657 player) {
        if (launchPad.isPublic().booleanValue()) {
            return true;
        }
        if (launchPad.whitelist().contains(player.method_5477().getString())) {
            return true;
        }
        return launchPad.owner().equals(player.method_5477().getString());
    }

    public static void saveLaunchPad(@Nullable LaunchPad launchPad, class_2487 tag) {
        if (launchPad != null) {
            tag.method_10556("null", false);
            tag.method_10569("id", launchPad.id());
            return;
        }
        tag.method_10556("null", true);
    }

    public static Collection<String> getLaunchPadNames(class_1657 player) {
        return LaunchPadLauncher.LAUNCH_PADS.launchPads().stream().filter(launchPad -> launchPad.owner().equals(player.method_5477().getString())).map(LaunchPad::name).toList();
    }

    public static Collection<String> getLaunchPadNames() {
        return LaunchPadLauncher.LAUNCH_PADS.launchPads().stream().map(l -> "\"" + l.name() + "\"").toList();
    }

    public static Collection<LaunchPad> getPlayerLaunchPad(class_1657 player) {
        return LaunchPadLauncher.LAUNCH_PADS.launchPads().stream().filter(launchPad -> launchPad.owner().equals(player.method_5477().getString())).toList();
    }

    @Nullable
    public static LaunchPad loadLaunchPad(class_2487 tag) {
        if (tag.method_10577("null")) {
            return null;
        }
        return LaunchPadUtils.getPadById(tag.method_10550("id"));
    }

    public static LaunchPad getPadById(int id) {
        for (LaunchPad lp : LaunchPadLauncher.LAUNCH_PADS.launchPads()) {
            if (lp.id() != id) continue;
            return lp;
        }
        return null;
    }

    public static LaunchPad getPadByNameAndDim(String name, class_5321<class_1937> dimension) {
        for (LaunchPad lp : LaunchPadLauncher.LAUNCH_PADS.launchPads()) {
            if (!lp.name().equals(name) || !lp.dimension().equals(dimension)) continue;
            return lp;
        }
        return null;
    }

    public static LaunchPad whitelistPlayer(LaunchPad launchPad, class_1657 player) {
        if (launchPad.whitelist().contains(player.method_5477().getString())) {
            return launchPad;
        }
        launchPad.whitelist().add(player.method_5477().getString());
        return launchPad;
    }

    public static int getNextLaunchPadId() {
        return LaunchPadLauncher.LAUNCH_PADS.launchPads().stream().mapToInt(LaunchPad::id).max().orElse(-1) + 1;
    }

    public static LaunchPad getPadByNameAndPlayer(String name, class_1657 player) {
        List<LaunchPad> lps = LaunchPadLauncher.LAUNCH_PADS.launchPads().stream().filter(l -> l.name().equals(name) && l.owner().equals(player.method_5477().getString())).toList();
        return lps.isEmpty() ? null : lps.getFirst();
    }
}

