/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils.capabilities.fluid;

import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.st0x0ef.stellaris.Stellaris;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public abstract class SingleFluidStorage
implements UniversalFluidStorage {
    protected FluidStack stack = FluidStack.empty();
    protected long capacity;
    protected long maxFill;
    protected long maxDrain;

    public SingleFluidStorage(long capacity, long maxFill, long maxDrain) {
        this.capacity = capacity;
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
    }

    public SingleFluidStorage(long capacity) {
        this(capacity, capacity, capacity);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        if (tank != 0) {
            Stellaris.LOG.error("Tank {} does not exist. SingleFluidStorage only has 1 tank", (Object)tank);
        }
        return this.stack.copy();
    }

    public long getTankCapacity(int tank) {
        if (tank != 0) {
            Stellaris.LOG.error("Tank {} does not exist. SingleFluidStorage only has 1 tank", (Object)tank);
        }
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        if (tank != 0) {
            Stellaris.LOG.error("Tank {} does not exist. SingleFluidStorage only has 1 tank", (Object)tank);
        }
        return true;
    }

    public long getFluidValueInTank() {
        return this.stack.getAmount();
    }

    public void setFluidInTank(FluidStack stack) {
        this.stack = stack;
        this.stack.setAmount(Math.clamp(stack.getAmount(), 0L, this.getTankCapacity(0)));
        this.onChange();
    }

    public FluidStack drain(FluidStack stack, boolean simulate) {
        if (!this.isFluidValid(0, stack)) {
            return FluidStack.empty();
        }
        if (this.getFluidInTank(0).isEmpty()) {
            return FluidStack.empty();
        }
        if (this.getFluidInTank(0).getFluid() != stack.getFluid()) {
            return FluidStack.empty();
        }
        long drained = Math.min(stack.getAmount(), Math.min(this.maxDrain, stack.getAmount()));
        if (!simulate) {
            this.stack.shrink(drained);
            this.onChange();
        }
        return FluidStack.create((FluidStack)stack, (long)drained);
    }

    public long fill(FluidStack stack, boolean simulate) {
        if (!this.isFluidValid(0, stack)) {
            return 0L;
        }
        if (this.stack.getFluid() != stack.getFluid() && !this.stack.isEmpty()) {
            return 0L;
        }
        if (this.stack.getAmount() >= this.getTankCapacity(0)) {
            return 0L;
        }
        long filled = Math.clamp(this.getTankCapacity(0) - this.getFluidValueInTank(), 0L, Math.min(this.maxFill, stack.getAmount()));
        if (!simulate) {
            this.stack = stack.copyWithAmount(this.stack.getAmount() + filled);
            this.onChange();
        }
        return filled;
    }

    public FluidStack drainWithoutLimits(long maxAmount, boolean simulate) {
        long removedAmount = Math.min(maxAmount, this.stack.getAmount());
        if (!simulate) {
            this.stack.shrink(removedAmount);
            this.onChange();
        }
        return FluidStack.create((class_3611)this.stack.getFluid(), (long)removedAmount);
    }

    public FluidStack drainWithoutLimits(FluidStack stack, boolean simulate) {
        if (!this.isFluidValid(0, stack)) {
            return FluidStack.empty();
        }
        if (this.getFluidInTank(0).isEmpty()) {
            return FluidStack.empty();
        }
        if (this.getFluidInTank(0).getFluid() != stack.getFluid()) {
            return FluidStack.empty();
        }
        long drained = Math.min(stack.getAmount(), stack.getAmount());
        if (!simulate) {
            this.stack.shrink(drained);
            this.onChange();
        }
        return FluidStack.create((FluidStack)stack, (long)drained);
    }

    public long fillWithoutLimits(FluidStack stack, boolean simulate) {
        if (!this.isFluidValid(0, stack)) {
            return 0L;
        }
        if (this.stack.getFluid() != stack.getFluid() && !this.stack.isEmpty()) {
            return 0L;
        }
        if (this.stack.getAmount() >= this.getTankCapacity(0)) {
            return 0L;
        }
        long filled = Math.clamp(this.getTankCapacity(0) - this.getFluidValueInTank(), 0L, stack.getAmount());
        if (!simulate) {
            this.stack = stack.copyWithAmount(this.getFluidValueInTank() + filled);
            this.onChange();
        }
        return filled;
    }

    public void save(class_2487 compoundTag, class_7225.class_7874 provider, String name) {
        if (this.isEmpty()) {
            return;
        }
        if (!this.getFluidInTank(0).isEmpty()) {
            compoundTag.method_10566(name + "-singleFluid", FluidStackHooks.write((class_7225.class_7874)provider, (FluidStack)this.getFluidInTank(0), (class_2520)new class_2487()));
        }
    }

    public void load(class_2487 compoundTag, class_7225.class_7874 provider, String name) {
        if (!compoundTag.method_10545(name + "-singleFluid")) {
            return;
        }
        this.setFluidInTank(FluidStackHooks.readOptional((class_7225.class_7874)provider, (class_2487)((class_2487)compoundTag.method_10580(name + "-singleFluid"))));
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean canGrow() {
        return this.stack.getAmount() < this.capacity;
    }

    @NotNull
    public Iterator<FluidStack> iterator() {
        return List.of(this.stack).iterator();
    }

    protected abstract void onChange();
}

