/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class LanderOverlay {
    public static final ResourceLocation WARNING = ResourceLocationUtils.texture("overlay/warning");

    public static void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Entity vehicle = player.getVehicle();
        if (player.getVehicle() instanceof LanderEntity && !player.getVehicle().isInWall() && !player.isInWater()) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            float sin = (float)Math.sin(((float)mc.level.getDayTime() + deltaTracker.getGameTimeDeltaPartialTick(true)) / 6.0f);
            float flash = Mth.clamp((float)sin, (float)0.0f, (float)4.0f);
            RenderSystem.setShaderColor((float)flash, (float)flash, (float)flash, (float)flash);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WARNING);
            graphics.blit(WARNING, graphics.guiWidth() / 2 - 58, 50, 0.0f, 0.0f, 116, 21, 116, 21);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double speed = (double)Math.round(100.0 * vehicle.getDeltaMovement().y()) / 100.0;
            MutableComponent message = Component.translatable((String)"message.stellaris.speed", (Object[])new Object[]{speed});
            graphics.drawString(Minecraft.getInstance().font, (Component)message, graphics.guiWidth() / 2 - 29, 80, -3407872);
        }
    }
}

