/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VenusRainParticle
extends TextureSheetParticle {
    public VenusRainParticle(ClientLevel world, double x, double y, double z, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.quadSize *= 1.0f;
        this.hasPhysics = true;
        this.speedUpWhenYMotionIsBlocked = true;
        this.xd *= 0.3;
        this.yd = this.random.nextDouble() * 0.2 + 0.1;
        this.zd *= 0.3;
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.lifetime = (int)(8.0 / (this.random.nextDouble() * 0.8 + 0.2));
        this.pickSprite(spriteSet);
    }

    public void tick() {
        super.tick();
        if (this.onGround) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Provider(SpriteSet spriteSet) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VenusRainParticle(level, x, y, z, this.spriteSet);
        }
    }
}

